/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression;

import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.RowValue;
import com.hazelcast.sql.impl.expression.UniExpressionWithType;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class ToRowFunction
extends UniExpressionWithType<RowValue>
implements IdentifiedDataSerializable {
    public ToRowFunction() {
    }

    private ToRowFunction(Expression<?> operand) {
        super(operand, QueryDataType.ROW);
    }

    public static ToRowFunction create(Expression<?> operand) {
        return new ToRowFunction(operand);
    }

    public RowValue eval(Row row, ExpressionEvalContext context) {
        Object object = this.operand.eval(row, context);
        QueryDataType queryDataType = this.operand.getType();
        return this.convert(object, queryDataType, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private RowValue convert(Object obj, QueryDataType dataType, Set<Object> seenObjects) {
        if (obj instanceof GenericRecord) {
            throw QueryException.error((String)"TO_ROW function is only supported for Java types");
        }
        if (!seenObjects.add(obj)) {
            throw QueryException.error((int)2000, (String)"Cycle detected in row value");
        }
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        for (QueryDataType.QueryDataTypeField field : dataType.getObjectFields()) {
            Object fieldValue = ReflectionUtils.getFieldValue((String)field.getName(), (Object)obj);
            if (!field.getDataType().isCustomType() || fieldValue == null) {
                fieldValues.add(fieldValue);
                continue;
            }
            fieldValues.add(this.convert(fieldValue, field.getDataType(), seenObjects));
        }
        return new RowValue(fieldValues);
    }

    public QueryDataType getType() {
        return QueryDataType.ROW;
    }

    public int getFactoryId() {
        return JetSqlSerializerHook.F_ID;
    }

    public int getClassId() {
        return 25;
    }
}

