/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.WriteJdbcP;
import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractJdbcSqlConnectorProcessorSupplier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.security.impl.function.SecuredFunction;
import com.hazelcast.security.permission.ConnectorPermission;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.CommonDataSource;

public class DeleteProcessorSupplier
extends AbstractJdbcSqlConnectorProcessorSupplier
implements ProcessorSupplier,
DataSerializable,
SecuredFunction {
    private String query;
    private int batchLimit;

    public DeleteProcessorSupplier() {
    }

    public DeleteProcessorSupplier(String externalDataStoreRef, String query, int batchLimit) {
        super(externalDataStoreRef);
        this.query = query;
        this.batchLimit = batchLimit;
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<WriteJdbcP> processors = new ArrayList<WriteJdbcP>(count);
        for (int i = 0; i < count; ++i) {
            WriteJdbcP processor = new WriteJdbcP(this.query, (CommonDataSource)this.dataSource, (BiConsumerEx & Serializable)(ps, row) -> {
                for (int j = 0; j < row.getFieldCount(); ++j) {
                    ps.setObject(j + 1, row.get(j));
                }
            }, false, this.batchLimit);
            processors.add(processor);
        }
        return processors;
    }

    @Nullable
    public List<Permission> permissions() {
        return Collections.singletonList(ConnectorPermission.jdbc((String)this.externalDataStoreRef, (String)"write"));
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.externalDataStoreRef);
        out.writeString(this.query);
        out.writeInt(this.batchLimit);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.externalDataStoreRef = in.readString();
        this.query = in.readString();
        this.batchLimit = in.readInt();
    }
}

