/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.sql.impl.connector.generator.SeriesSqlConnector;
import com.hazelcast.jet.sql.impl.connector.generator.SeriesTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastSpecificTableFunction;
import com.hazelcast.jet.sql.impl.schema.HazelcastSqlOperandMetadata;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableFunctionParameter;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableStatistic;
import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.HazelcastOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.expression.Expression;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SeriesGeneratorTableFunction
extends HazelcastSpecificTableFunction {
    private static final String SCHEMA_NAME_SERIES = "series";
    private static final String FUNCTION_NAME = "GENERATE_SERIES";
    private static final List<HazelcastTableFunctionParameter> PARAMETERS = Arrays.asList(new HazelcastTableFunctionParameter(0, "start", SqlTypeName.INTEGER, false, TypedOperandChecker.INTEGER), new HazelcastTableFunctionParameter(1, "stop", SqlTypeName.INTEGER, false, TypedOperandChecker.INTEGER), new HazelcastTableFunctionParameter(2, "step", SqlTypeName.INTEGER, true, TypedOperandChecker.INTEGER));

    public SeriesGeneratorTableFunction() {
        super(FUNCTION_NAME, SeriesOperandMetadata.INSTANCE, binding -> SeriesGeneratorTableFunction.toTable0(Collections.emptyList()).getRowType(binding.getTypeFactory()), SeriesSqlConnector.INSTANCE);
    }

    @Override
    public HazelcastTable toTable(List<Expression<?>> argumentExpressions) {
        return SeriesGeneratorTableFunction.toTable0(argumentExpressions);
    }

    private static HazelcastTable toTable0(List<Expression<?>> argumentExpressions) {
        SeriesTable table = SeriesSqlConnector.createTable(SCHEMA_NAME_SERIES, SeriesGeneratorTableFunction.randomName(), argumentExpressions);
        return new HazelcastTable(table, new HazelcastTableStatistic(0L));
    }

    private static String randomName() {
        return "series_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }

    private static final class SeriesOperandMetadata
    extends HazelcastSqlOperandMetadata {
        private static final SeriesOperandMetadata INSTANCE = new SeriesOperandMetadata();

        private SeriesOperandMetadata() {
            super(PARAMETERS, new HazelcastOperandTypeInference(PARAMETERS, new ReplaceUnknownOperandTypeInference(SqlTypeName.INTEGER)));
        }

        @Override
        protected boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
            return true;
        }
    }
}

