/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.jet.sql.impl.expression.json.JsonCreationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.util.PriorityQueue;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class OrderedJsonArrayAggAggregation
implements SqlAggregation {
    private final PriorityQueue<JetSqlRow> objects;
    private final boolean isAbsentOnNull;
    private final int aggIndex;

    private OrderedJsonArrayAggAggregation(ExpressionUtil.SqlRowComparator comparator, boolean isAbsentOnNull, int aggIndex) {
        this.isAbsentOnNull = isAbsentOnNull;
        this.aggIndex = aggIndex;
        this.objects = new PriorityQueue(comparator);
    }

    public static OrderedJsonArrayAggAggregation create(ExpressionUtil.SqlRowComparator comparator, boolean isAbsentOnNull, int aggIndex) {
        return new OrderedJsonArrayAggAggregation(comparator, isAbsentOnNull, aggIndex);
    }

    @Override
    public void accumulate(Object value) {
        JetSqlRow row = (JetSqlRow)value;
        this.objects.add(row);
    }

    @Override
    public void combine(SqlAggregation other) {
        throw new UnsupportedOperationException("OrderedJsonArrayAgg combine() method should not be called");
    }

    @Override
    public Object collect() {
        StringBuilder sb = new StringBuilder();
        boolean firstValue = true;
        sb.append("[");
        while (!this.objects.isEmpty()) {
            JetSqlRow row = this.objects.poll();
            Object value = row.get(this.aggIndex);
            if (value == null) {
                if (this.isAbsentOnNull) continue;
                if (!firstValue) {
                    sb.append(",");
                }
                sb.append("null");
                firstValue = false;
                continue;
            }
            if (!firstValue) {
                sb.append(",");
            }
            sb.append(JsonCreationUtil.serializeValue(value));
            firstValue = false;
        }
        sb.append("]");
        if (firstValue) {
            return null;
        }
        return new HazelcastJsonValue(sb.toString());
    }

    public void writeData(ObjectDataOutput out) {
        throw new UnsupportedOperationException("OrderedJsonArrayAgg writeData() method should not be called");
    }

    public void readData(ObjectDataInput in) {
        throw new UnsupportedOperationException("OrderedJsonArrayAgg readData() should not be called");
    }
}

