/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.esri.core.geometry;

import com.hazelcast.com.esri.core.geometry.AttributeStreamOfDbl;
import com.hazelcast.com.esri.core.geometry.AttributeStreamOfInt32;
import com.hazelcast.com.esri.core.geometry.AttributeStreamOfInt8;
import com.hazelcast.com.esri.core.geometry.Envelope;
import com.hazelcast.com.esri.core.geometry.Envelope1D;
import com.hazelcast.com.esri.core.geometry.Geometry;
import com.hazelcast.com.esri.core.geometry.GeometryException;
import com.hazelcast.com.esri.core.geometry.MultiPathImpl;
import com.hazelcast.com.esri.core.geometry.MultiPoint;
import com.hazelcast.com.esri.core.geometry.MultiPointImpl;
import com.hazelcast.com.esri.core.geometry.NumberUtils;
import com.hazelcast.com.esri.core.geometry.OperatorExportToWkt;
import com.hazelcast.com.esri.core.geometry.Point;
import com.hazelcast.com.esri.core.geometry.Polygon;
import com.hazelcast.com.esri.core.geometry.Polyline;
import com.hazelcast.com.esri.core.geometry.ProgressTracker;
import com.hazelcast.com.esri.core.geometry.StringUtils;
import com.hazelcast.com.esri.core.geometry.VertexDescription;

class OperatorExportToWktLocal
extends OperatorExportToWkt {
    OperatorExportToWktLocal() {
    }

    @Override
    public String execute(int export_flags, Geometry geometry, ProgressTracker progress_tracker) {
        StringBuilder string = new StringBuilder();
        OperatorExportToWktLocal.exportToWkt(export_flags, geometry, string);
        return string.toString();
    }

    static void exportToWkt(int export_flags, Geometry geometry, StringBuilder string) {
        int type = geometry.getType().value();
        switch (type) {
            case 1736: {
                if ((export_flags & 4) != 0 || (export_flags & 8) != 0 || (export_flags & 1) != 0 || (export_flags & 2) != 0) {
                    throw new IllegalArgumentException("Cannot export a Polygon as (Multi)LineString/(Multi)Point : " + export_flags);
                }
                OperatorExportToWktLocal.exportPolygonToWkt(export_flags, (Polygon)geometry, string);
                return;
            }
            case 1607: {
                if ((export_flags & 0x10) != 0 || (export_flags & 0x20) != 0 || (export_flags & 1) != 0 || (export_flags & 2) != 0) {
                    throw new IllegalArgumentException("Cannot export a Polyline as (Multi)Polygon/(Multi)Point : " + export_flags);
                }
                OperatorExportToWktLocal.exportPolylineToWkt(export_flags, (Polyline)geometry, string);
                return;
            }
            case 550: {
                if ((export_flags & 4) != 0 || (export_flags & 8) != 0 || (export_flags & 0x10) != 0 || (export_flags & 0x20) != 0) {
                    throw new IllegalArgumentException("Cannot export a MultiPoint as (Multi)LineString/(Multi)Polygon: " + export_flags);
                }
                OperatorExportToWktLocal.exportMultiPointToWkt(export_flags, (MultiPoint)geometry, string);
                return;
            }
            case 33: {
                if ((export_flags & 4) != 0 || (export_flags & 8) != 0 || (export_flags & 0x10) != 0 || (export_flags & 0x20) != 0) {
                    throw new IllegalArgumentException("Cannot export a Point as (Multi)LineString/(Multi)Polygon: " + export_flags);
                }
                OperatorExportToWktLocal.exportPointToWkt(export_flags, (Point)geometry, string);
                return;
            }
            case 197: {
                if ((export_flags & 4) != 0 || (export_flags & 8) != 0 || (export_flags & 1) != 0 || (export_flags & 2) != 0) {
                    throw new IllegalArgumentException("Cannot export an Envelope as (Multi)LineString/(Multi)Point: " + export_flags);
                }
                OperatorExportToWktLocal.exportEnvelopeToWkt(export_flags, (Envelope)geometry, string);
                return;
            }
        }
        throw GeometryException.GeometryInternalError();
    }

    static void exportPolygonToWkt(int export_flags, Polygon polygon, StringBuilder string) {
        int simple;
        MultiPathImpl polygon_impl = (MultiPathImpl)polygon._getImpl();
        if ((export_flags & 0x1000) != 0 && (simple = polygon_impl.getIsSimple(0.0)) != 2) {
            throw new GeometryException("corrupted geometry");
        }
        int point_count = polygon.getPointCount();
        int polygon_count = polygon_impl.getOGCPolygonCount();
        if (point_count > 0 && polygon_count == 0) {
            throw new GeometryException("corrupted geometry");
        }
        int precision = 17 - (7 & export_flags >> 13);
        boolean b_export_zs = polygon_impl.hasAttribute(1) && (export_flags & 0x40) == 0;
        boolean b_export_ms = polygon_impl.hasAttribute(2) && (export_flags & 0x80) == 0;
        int path_count = 0;
        AttributeStreamOfDbl position = null;
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfInt8 path_flags = null;
        AttributeStreamOfInt32 paths = null;
        if (point_count > 0) {
            position = (AttributeStreamOfDbl)polygon_impl.getAttributeStreamRef(0);
            path_flags = polygon_impl.getPathFlagsStreamRef();
            paths = polygon_impl.getPathStreamRef();
            path_count = polygon_impl.getPathCount();
            if (b_export_zs && polygon_impl._attributeStreamIsAllocated(1)) {
                zs = (AttributeStreamOfDbl)polygon_impl.getAttributeStreamRef(1);
            }
            if (b_export_ms && polygon_impl._attributeStreamIsAllocated(2)) {
                ms = (AttributeStreamOfDbl)polygon_impl.getAttributeStreamRef(2);
            }
        }
        if ((export_flags & 0x10) != 0) {
            if (polygon_count > 1) {
                throw new IllegalArgumentException("Cannot export a Polygon with specified export flags: " + export_flags);
            }
            OperatorExportToWktLocal.polygonTaggedText_(precision, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, path_count, string);
        } else {
            OperatorExportToWktLocal.multiPolygonTaggedText_(precision, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, polygon_count, path_count, string);
        }
    }

    static void exportPolylineToWkt(int export_flags, Polyline polyline, StringBuilder string) {
        MultiPathImpl polyline_impl = (MultiPathImpl)polyline._getImpl();
        int point_count = polyline_impl.getPointCount();
        int path_count = polyline_impl.getPathCount();
        if (point_count > 0 && path_count == 0) {
            throw new GeometryException("corrupted geometry");
        }
        int precision = 17 - (7 & export_flags >> 13);
        boolean b_export_zs = polyline_impl.hasAttribute(1) && (export_flags & 0x40) == 0;
        boolean b_export_ms = polyline_impl.hasAttribute(2) && (export_flags & 0x80) == 0;
        AttributeStreamOfDbl position = null;
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfInt8 path_flags = null;
        AttributeStreamOfInt32 paths = null;
        if (point_count > 0) {
            position = (AttributeStreamOfDbl)polyline_impl.getAttributeStreamRef(0);
            path_flags = polyline_impl.getPathFlagsStreamRef();
            paths = polyline_impl.getPathStreamRef();
            if (b_export_zs && polyline_impl._attributeStreamIsAllocated(1)) {
                zs = (AttributeStreamOfDbl)polyline_impl.getAttributeStreamRef(1);
            }
            if (b_export_ms && polyline_impl._attributeStreamIsAllocated(2)) {
                ms = (AttributeStreamOfDbl)polyline_impl.getAttributeStreamRef(2);
            }
        }
        if ((export_flags & 4) != 0) {
            if (path_count > 1) {
                throw new IllegalArgumentException("Cannot export a LineString with specified export flags: " + export_flags);
            }
            OperatorExportToWktLocal.lineStringTaggedText_(precision, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, string);
        } else {
            OperatorExportToWktLocal.multiLineStringTaggedText_(precision, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, path_count, string);
        }
    }

    static void exportMultiPointToWkt(int export_flags, MultiPoint multipoint, StringBuilder string) {
        MultiPointImpl multipoint_impl = (MultiPointImpl)multipoint._getImpl();
        int point_count = multipoint_impl.getPointCount();
        int precision = 17 - (7 & export_flags >> 13);
        boolean b_export_zs = multipoint_impl.hasAttribute(1) && (export_flags & 0x40) == 0;
        boolean b_export_ms = multipoint_impl.hasAttribute(2) && (export_flags & 0x80) == 0;
        AttributeStreamOfDbl position = null;
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        if (point_count > 0) {
            position = (AttributeStreamOfDbl)multipoint_impl.getAttributeStreamRef(0);
            if (b_export_zs && multipoint_impl._attributeStreamIsAllocated(1)) {
                zs = (AttributeStreamOfDbl)multipoint_impl.getAttributeStreamRef(1);
            }
            if (b_export_ms && multipoint_impl._attributeStreamIsAllocated(2)) {
                ms = (AttributeStreamOfDbl)multipoint_impl.getAttributeStreamRef(2);
            }
        }
        if ((export_flags & 1) != 0) {
            if (point_count > 1) {
                throw new IllegalArgumentException("Cannot export a Point with specified export flags: " + export_flags);
            }
            OperatorExportToWktLocal.pointTaggedTextFromMultiPoint_(precision, b_export_zs, b_export_ms, zs, ms, position, string);
        } else {
            OperatorExportToWktLocal.multiPointTaggedText_(precision, b_export_zs, b_export_ms, zs, ms, position, point_count, string);
        }
    }

    static void exportPointToWkt(int export_flags, Point point, StringBuilder string) {
        int precision = 17 - (7 & export_flags >> 13);
        boolean b_export_zs = point.hasAttribute(1) && (export_flags & 0x40) == 0;
        boolean b_export_ms = point.hasAttribute(2) && (export_flags & 0x80) == 0;
        double x = Double.NaN;
        double y = Double.NaN;
        double z = Double.NaN;
        double m4 = Double.NaN;
        if (!point.isEmpty()) {
            x = point.getX();
            y = point.getY();
            if (b_export_zs) {
                z = point.getZ();
            }
            if (b_export_ms) {
                m4 = point.getM();
            }
        }
        if ((export_flags & 2) != 0) {
            OperatorExportToWktLocal.multiPointTaggedTextFromPoint_(precision, b_export_zs, b_export_ms, x, y, z, m4, string);
        } else {
            OperatorExportToWktLocal.pointTaggedText_(precision, b_export_zs, b_export_ms, x, y, z, m4, string);
        }
    }

    static void exportEnvelopeToWkt(int export_flags, Envelope envelope, StringBuilder string) {
        int precision = 17 - (7 & export_flags >> 13);
        boolean b_export_zs = envelope.hasAttribute(1) && (export_flags & 0x40) == 0;
        boolean b_export_ms = envelope.hasAttribute(2) && (export_flags & 0x80) == 0;
        double xmin = Double.NaN;
        double ymin = Double.NaN;
        double xmax = Double.NaN;
        double ymax = Double.NaN;
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        double mmin = Double.NaN;
        double mmax = Double.NaN;
        if (!envelope.isEmpty()) {
            Envelope1D interval;
            xmin = envelope.getXMin();
            ymin = envelope.getYMin();
            xmax = envelope.getXMax();
            ymax = envelope.getYMax();
            if (b_export_zs) {
                interval = envelope.queryInterval(1, 0);
                zmin = interval.vmin;
                zmax = interval.vmax;
            }
            if (b_export_ms) {
                interval = envelope.queryInterval(2, 0);
                mmin = interval.vmin;
                mmax = interval.vmax;
            }
        }
        if ((export_flags & 0x20) != 0) {
            OperatorExportToWktLocal.multiPolygonTaggedTextFromEnvelope_(precision, b_export_zs, b_export_ms, xmin, ymin, xmax, ymax, zmin, zmax, mmin, mmax, string);
        } else {
            OperatorExportToWktLocal.polygonTaggedTextFromEnvelope_(precision, b_export_zs, b_export_ms, xmin, ymin, xmax, ymax, zmin, zmax, mmin, mmax, string);
        }
    }

    static void multiPolygonTaggedText_(int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt8 path_flags, AttributeStreamOfInt32 paths, int polygon_count, int path_count, StringBuilder string) {
        string.append("MULTIPOLYGON ");
        if (b_export_zs && b_export_ms) {
            string.append("ZM ");
        } else if (b_export_zs && !b_export_ms) {
            string.append("Z ");
        } else if (!b_export_zs && b_export_ms) {
            string.append("M ");
        }
        if (position == null) {
            string.append("EMPTY");
            return;
        }
        string.append('(');
        OperatorExportToWktLocal.multiPolygonText_(precision, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, polygon_count, path_count, string);
        string.append(')');
    }

    static void multiPolygonTaggedTextFromEnvelope_(int precision, boolean b_export_zs, boolean b_export_ms, double xmin, double ymin, double xmax, double ymax, double zmin, double zmax, double mmin, double mmax, StringBuilder string) {
        string.append("MULTIPOLYGON ");
        if (b_export_zs && b_export_ms) {
            string.append("ZM ");
        } else if (b_export_zs && !b_export_ms) {
            string.append("Z ");
        } else if (!b_export_zs && b_export_ms) {
            string.append("M ");
        }
        if (NumberUtils.isNaN(xmin)) {
            string.append("EMPTY");
            return;
        }
        string.append('(');
        OperatorExportToWktLocal.writeEnvelopeAsWktPolygon_(precision, b_export_zs, b_export_ms, xmin, ymin, xmax, ymax, zmin, zmax, mmin, mmax, string);
        string.append(')');
    }

    static void multiLineStringTaggedText_(int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt8 path_flags, AttributeStreamOfInt32 paths, int path_count, StringBuilder string) {
        string.append("MULTILINESTRING ");
        if (b_export_zs && b_export_ms) {
            string.append("ZM ");
        } else if (b_export_zs && !b_export_ms) {
            string.append("Z ");
        } else if (!b_export_zs && b_export_ms) {
            string.append("M ");
        }
        if (position == null) {
            string.append("EMPTY");
            return;
        }
        string.append('(');
        OperatorExportToWktLocal.multiLineStringText_(precision, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, path_count, string);
        string.append(')');
    }

    static void multiPointTaggedText_(int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, int point_count, StringBuilder string) {
        string.append("MULTIPOINT ");
        if (b_export_zs && b_export_ms) {
            string.append("ZM ");
        } else if (b_export_zs && !b_export_ms) {
            string.append("Z ");
        } else if (!b_export_zs && b_export_ms) {
            string.append("M ");
        }
        if (position == null) {
            string.append("EMPTY");
            return;
        }
        string.append('(');
        OperatorExportToWktLocal.multiPointText_(precision, b_export_zs, b_export_ms, zs, ms, position, point_count, string);
        string.append(')');
    }

    static void multiPointTaggedTextFromPoint_(int precision, boolean b_export_zs, boolean b_export_ms, double x, double y, double z, double m4, StringBuilder string) {
        string.append("MULTIPOINT ");
        if (b_export_zs && b_export_ms) {
            string.append("ZM ");
        } else if (b_export_zs && !b_export_ms) {
            string.append("Z ");
        } else if (!b_export_zs && b_export_ms) {
            string.append("M ");
        }
        if (NumberUtils.isNaN(x)) {
            string.append("EMPTY");
            return;
        }
        string.append('(');
        OperatorExportToWktLocal.pointText_(precision, b_export_zs, b_export_ms, x, y, z, m4, string);
        string.append(')');
    }

    static void polygonTaggedText_(int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt8 path_flags, AttributeStreamOfInt32 paths, int path_count, StringBuilder string) {
        string.append("POLYGON ");
        if (b_export_zs && b_export_ms) {
            string.append("ZM ");
        } else if (b_export_zs && !b_export_ms) {
            string.append("Z ");
        } else if (!b_export_zs && b_export_ms) {
            string.append("M ");
        }
        if (position == null) {
            string.append("EMPTY");
            return;
        }
        OperatorExportToWktLocal.polygonText_(precision, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, 0, path_count, string);
    }

    static void polygonTaggedTextFromEnvelope_(int precision, boolean b_export_zs, boolean b_export_ms, double xmin, double ymin, double xmax, double ymax, double zmin, double zmax, double mmin, double mmax, StringBuilder string) {
        string.append("POLYGON ");
        if (b_export_zs && b_export_ms) {
            string.append("ZM ");
        } else if (b_export_zs && !b_export_ms) {
            string.append("Z ");
        } else if (!b_export_zs && b_export_ms) {
            string.append("M ");
        }
        if (NumberUtils.isNaN(xmin)) {
            string.append("EMPTY");
            return;
        }
        OperatorExportToWktLocal.writeEnvelopeAsWktPolygon_(precision, b_export_zs, b_export_ms, xmin, ymin, xmax, ymax, zmin, zmax, mmin, mmax, string);
    }

    static void lineStringTaggedText_(int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt8 path_flags, AttributeStreamOfInt32 paths, StringBuilder string) {
        string.append("LINESTRING ");
        if (b_export_zs && b_export_ms) {
            string.append("ZM ");
        } else if (b_export_zs && !b_export_ms) {
            string.append("Z ");
        } else if (!b_export_zs && b_export_ms) {
            string.append("M ");
        }
        if (position == null) {
            string.append("EMPTY");
            return;
        }
        boolean b_closed = (path_flags.read(0) & 1) != 0;
        OperatorExportToWktLocal.lineStringText_(false, b_closed, precision, b_export_zs, b_export_ms, zs, ms, position, paths, 0, string);
    }

    static void pointTaggedText_(int precision, boolean b_export_zs, boolean b_export_ms, double x, double y, double z, double m4, StringBuilder string) {
        string.append("POINT ");
        if (b_export_zs && b_export_ms) {
            string.append("ZM ");
        } else if (b_export_zs && !b_export_ms) {
            string.append("Z ");
        } else if (!b_export_zs && b_export_ms) {
            string.append("M ");
        }
        if (NumberUtils.isNaN(x)) {
            string.append("EMPTY");
            return;
        }
        OperatorExportToWktLocal.pointText_(precision, b_export_zs, b_export_ms, x, y, z, m4, string);
    }

    static void pointTaggedTextFromMultiPoint_(int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, StringBuilder string) {
        string.append("POINT ");
        if (b_export_zs && b_export_ms) {
            string.append("ZM ");
        } else if (b_export_zs && !b_export_ms) {
            string.append("Z ");
        } else if (!b_export_zs && b_export_ms) {
            string.append("M ");
        }
        if (position == null) {
            string.append("EMPTY");
            return;
        }
        OperatorExportToWktLocal.pointText_(precision, b_export_zs, b_export_ms, zs, ms, position, 0, string);
    }

    static void multiPolygonText_(int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt8 path_flags, AttributeStreamOfInt32 paths, int polygon_count, int path_count, StringBuilder string) {
        int polygon_end;
        int polygon_start = 0;
        for (polygon_end = 1; polygon_end < path_count && (path_flags.read(polygon_end) & 4) == 0; ++polygon_end) {
        }
        OperatorExportToWktLocal.polygonText_(precision, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, polygon_start, polygon_end, string);
        for (int ipolygon = 1; ipolygon < polygon_count; ++ipolygon) {
            polygon_start = polygon_end++;
            while (polygon_end < path_count && (path_flags.read(polygon_end) & 4) == 0) {
                ++polygon_end;
            }
            string.append(", ");
            OperatorExportToWktLocal.polygonText_(precision, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, polygon_start, polygon_end, string);
        }
    }

    static void multiLineStringText_(int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt8 path_flags, AttributeStreamOfInt32 paths, int path_count, StringBuilder string) {
        boolean b_closed = (path_flags.read(0) & 1) != 0;
        OperatorExportToWktLocal.lineStringText_(false, b_closed, precision, b_export_zs, b_export_ms, zs, ms, position, paths, 0, string);
        for (int path = 1; path < path_count; ++path) {
            string.append(", ");
            b_closed = (path_flags.read(path) & 1) != 0;
            OperatorExportToWktLocal.lineStringText_(false, b_closed, precision, b_export_zs, b_export_ms, zs, ms, position, paths, path, string);
        }
    }

    static void multiPointText_(int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, int point_count, StringBuilder string) {
        OperatorExportToWktLocal.pointText_(precision, b_export_zs, b_export_ms, zs, ms, position, 0, string);
        for (int point = 1; point < point_count; ++point) {
            string.append(", ");
            OperatorExportToWktLocal.pointText_(precision, b_export_zs, b_export_ms, zs, ms, position, point, string);
        }
    }

    static void polygonText_(int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt8 path_flags, AttributeStreamOfInt32 paths, int polygon_start, int polygon_end, StringBuilder string) {
        string.append('(');
        OperatorExportToWktLocal.lineStringText_(true, true, precision, b_export_zs, b_export_ms, zs, ms, position, paths, polygon_start, string);
        for (int path = polygon_start + 1; path < polygon_end; ++path) {
            string.append(", ");
            OperatorExportToWktLocal.lineStringText_(true, true, precision, b_export_zs, b_export_ms, zs, ms, position, paths, path, string);
        }
        string.append(')');
    }

    static void lineStringText_(boolean bRing, boolean b_closed, int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt32 paths, int path, StringBuilder string) {
        int iend;
        int istart = paths.read(path);
        if (istart == (iend = paths.read(path + 1))) {
            string.append("EMPTY");
            return;
        }
        string.append('(');
        if (bRing) {
            OperatorExportToWktLocal.point_(precision, b_export_zs, b_export_ms, zs, ms, position, istart, string);
            string.append(", ");
            for (int point = iend - 1; point >= istart + 1; --point) {
                OperatorExportToWktLocal.point_(precision, b_export_zs, b_export_ms, zs, ms, position, point, string);
                string.append(", ");
            }
            OperatorExportToWktLocal.point_(precision, b_export_zs, b_export_ms, zs, ms, position, istart, string);
        } else {
            for (int point = istart; point < iend - 1; ++point) {
                OperatorExportToWktLocal.point_(precision, b_export_zs, b_export_ms, zs, ms, position, point, string);
                string.append(", ");
            }
            OperatorExportToWktLocal.point_(precision, b_export_zs, b_export_ms, zs, ms, position, iend - 1, string);
            if (b_closed) {
                string.append(", ");
                OperatorExportToWktLocal.point_(precision, b_export_zs, b_export_ms, zs, ms, position, istart, string);
            }
        }
        string.append(')');
    }

    static int pointText_(int precision, boolean b_export_zs, boolean b_export_ms, double x, double y, double z, double m4, StringBuilder string) {
        string.append('(');
        OperatorExportToWktLocal.point_(precision, b_export_zs, b_export_ms, x, y, z, m4, string);
        string.append(')');
        return 1;
    }

    static void pointText_(int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, int point, StringBuilder string) {
        double x = position.read(2 * point);
        double y = position.read(2 * point + 1);
        double z = Double.NaN;
        double m4 = Double.NaN;
        if (b_export_zs) {
            double d = z = zs != null ? zs.read(point) : VertexDescription.getDefaultValue(1);
        }
        if (b_export_ms) {
            m4 = ms != null ? ms.read(point) : VertexDescription.getDefaultValue(2);
        }
        OperatorExportToWktLocal.pointText_(precision, b_export_zs, b_export_ms, x, y, z, m4, string);
    }

    static void point_(int precision, boolean b_export_zs, boolean b_export_ms, double x, double y, double z, double m4, StringBuilder string) {
        OperatorExportToWktLocal.writeSignedNumericLiteral_(x, precision, string);
        string.append(' ');
        OperatorExportToWktLocal.writeSignedNumericLiteral_(y, precision, string);
        if (b_export_zs) {
            string.append(' ');
            OperatorExportToWktLocal.writeSignedNumericLiteral_(z, precision, string);
        }
        if (b_export_ms) {
            string.append(' ');
            OperatorExportToWktLocal.writeSignedNumericLiteral_(m4, precision, string);
        }
    }

    static void point_(int precision, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, int point, StringBuilder string) {
        double x = position.read(2 * point);
        double y = position.read(2 * point + 1);
        double z = Double.NaN;
        double m4 = Double.NaN;
        if (b_export_zs) {
            double d = z = zs != null ? zs.read(point) : VertexDescription.getDefaultValue(1);
        }
        if (b_export_ms) {
            m4 = ms != null ? ms.read(point) : VertexDescription.getDefaultValue(2);
        }
        OperatorExportToWktLocal.point_(precision, b_export_zs, b_export_ms, x, y, z, m4, string);
    }

    static boolean writeSignedNumericLiteral_(double v, int precision, StringBuilder string) {
        if (NumberUtils.isNaN(v)) {
            string.append("NAN");
            return false;
        }
        StringUtils.appendDouble(v, precision, string);
        return true;
    }

    static void writeEnvelopeAsWktPolygon_(int precision, boolean b_export_zs, boolean b_export_ms, double xmin, double ymin, double xmax, double ymax, double zmin, double zmax, double mmin, double mmax, StringBuilder string) {
        string.append("((");
        OperatorExportToWktLocal.writeSignedNumericLiteral_(xmin, precision, string);
        string.append(' ');
        OperatorExportToWktLocal.writeSignedNumericLiteral_(ymin, precision, string);
        if (b_export_zs) {
            string.append(' ');
            OperatorExportToWktLocal.writeSignedNumericLiteral_(zmin, precision, string);
        }
        if (b_export_ms) {
            string.append(' ');
            OperatorExportToWktLocal.writeSignedNumericLiteral_(mmin, precision, string);
        }
        string.append(", ");
        OperatorExportToWktLocal.writeSignedNumericLiteral_(xmax, precision, string);
        string.append(' ');
        OperatorExportToWktLocal.writeSignedNumericLiteral_(ymin, precision, string);
        if (b_export_zs) {
            string.append(' ');
            OperatorExportToWktLocal.writeSignedNumericLiteral_(zmax, precision, string);
        }
        if (b_export_ms) {
            string.append(' ');
            OperatorExportToWktLocal.writeSignedNumericLiteral_(mmax, precision, string);
        }
        string.append(", ");
        OperatorExportToWktLocal.writeSignedNumericLiteral_(xmax, precision, string);
        string.append(' ');
        OperatorExportToWktLocal.writeSignedNumericLiteral_(ymax, precision, string);
        if (b_export_zs) {
            string.append(' ');
            OperatorExportToWktLocal.writeSignedNumericLiteral_(zmin, precision, string);
        }
        if (b_export_ms) {
            string.append(' ');
            OperatorExportToWktLocal.writeSignedNumericLiteral_(mmin, precision, string);
        }
        string.append(", ");
        OperatorExportToWktLocal.writeSignedNumericLiteral_(xmin, precision, string);
        string.append(' ');
        OperatorExportToWktLocal.writeSignedNumericLiteral_(ymax, precision, string);
        if (b_export_zs) {
            string.append(' ');
            OperatorExportToWktLocal.writeSignedNumericLiteral_(zmax, precision, string);
        }
        if (b_export_ms) {
            string.append(' ');
            OperatorExportToWktLocal.writeSignedNumericLiteral_(mmax, precision, string);
        }
        string.append(", ");
        OperatorExportToWktLocal.writeSignedNumericLiteral_(xmin, precision, string);
        string.append(' ');
        OperatorExportToWktLocal.writeSignedNumericLiteral_(ymin, precision, string);
        if (b_export_zs) {
            string.append(' ');
            OperatorExportToWktLocal.writeSignedNumericLiteral_(zmin, precision, string);
        }
        if (b_export_ms) {
            string.append(' ');
            OperatorExportToWktLocal.writeSignedNumericLiteral_(mmin, precision, string);
        }
        string.append("))");
    }
}

