/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.python;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.grpc.impl.GrpcUtil;
import com.hazelcast.jet.pipeline.ServiceFactory;
import com.hazelcast.jet.python.JetToPythonServer;
import com.hazelcast.jet.python.PythonServiceConfig;
import com.hazelcast.jet.python.PythonServiceContext;
import com.hazelcast.jet.python.impl.grpc.InputMessage;
import com.hazelcast.jet.python.impl.grpc.JetToPythonGrpc;
import com.hazelcast.jet.python.impl.grpc.OutputMessage;
import com.hazelcast.logging.ILogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

final class PythonService {
    private static final int CREATE_CONTEXT_RETRY_COUNT = 2;
    private static final int CREATE_CONTEXT_RETRY_SLEEP_TIME_MILLIS = 1000;
    private static final String JET_TO_PYTHON_PREFIX = "jet_to_python_";
    static final String MAIN_SHELL_SCRIPT = "jet_to_python_main.sh";
    private final ILogger logger;
    private final JetToPythonServer server;
    private final ManagedChannel chan;
    private final StreamObserver<InputMessage> sink;
    private final Queue<CompletableFuture<List<String>>> futureQueue = new ConcurrentLinkedQueue<CompletableFuture<List<String>>>();
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private volatile Throwable exceptionInOutputObserver;

    PythonService(PythonServiceContext serviceContext) {
        this.logger = serviceContext.logger();
        this.server = new JetToPythonServer(serviceContext.runtimeBaseDir(), this.logger);
        try {
            int serverPort = this.server.start();
            this.chan = ((ManagedChannelBuilder)((ManagedChannelBuilder)serviceContext.channelFn().apply((Object)"127.0.0.1", (Object)serverPort)).usePlaintext()).build();
            JetToPythonGrpc.JetToPythonStub client = JetToPythonGrpc.newStub(this.chan);
            this.sink = client.streamingCall(new OutputMessageObserver());
        }
        catch (Throwable e) {
            this.server.stop();
            throw new JetException("PythonService initialization failed", e);
        }
    }

    @Nonnull
    static ServiceFactory<?, PythonService> factory(@Nonnull PythonServiceConfig cfg) {
        cfg.validate();
        ServiceFactory fac = ServiceFactory.withCreateContextFn((FunctionEx & Serializable)ctx -> PythonService.createContextWithRetry(ctx, cfg)).withDestroyContextFn(PythonServiceContext::destroy).withCreateServiceFn((BiFunctionEx & Serializable)(procCtx, serviceCtx) -> new PythonService((PythonServiceContext)serviceCtx)).withDestroyServiceFn(PythonService::destroy);
        if (cfg.baseDir() != null) {
            File baseDir = Objects.requireNonNull(cfg.baseDir());
            return fac.withAttachedDirectory(baseDir.toString(), baseDir);
        }
        File handlerFile = Objects.requireNonNull(cfg.handlerFile());
        return fac.withAttachedFile(handlerFile.toString(), handlerFile);
    }

    private static PythonServiceContext createContextWithRetry(ProcessorSupplier.Context context, PythonServiceConfig cfg) {
        JetException jetException = null;
        for (int i = 2; i >= 0; --i) {
            try {
                return new PythonServiceContext(context, cfg);
            }
            catch (JetException exception) {
                jetException = exception;
                context.logger().warning("PythonService context creation failed, " + (i > 0 ? "will retry" : "giving up"), (Throwable)exception);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new JetException((Throwable)e);
                }
            }
        }
        throw jetException;
    }

    CompletableFuture<List<String>> sendRequest(List<String> inputBatch) {
        this.checkForServerError();
        InputMessage.Builder requestBuilder = InputMessage.newBuilder();
        for (String item : inputBatch) {
            requestBuilder.addInputValue(item);
        }
        CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.futureQueue.add(future);
        this.sink.onNext(requestBuilder.build());
        return future;
    }

    private void checkForServerError() {
        if (this.completionLatch.getCount() == 0L) {
            throw new JetException("PythonService broke down: " + this.exceptionInOutputObserver, this.exceptionInOutputObserver);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    void destroy() {
        boolean interrupted = Thread.interrupted();
        try {
            this.sink.onCompleted();
            if (!this.completionLatch.await(1L, TimeUnit.SECONDS)) {
                this.logger.info("gRPC call has not completed on time");
            }
            GrpcUtil.shutdownChannel(this.chan, this.logger, 1L);
            this.server.stop();
        }
        catch (Exception e) {
            throw new JetException("PythonService.destroy() failed: " + e, (Throwable)e);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class OutputMessageObserver
    implements StreamObserver<OutputMessage> {
        private OutputMessageObserver() {
        }

        @Override
        public void onNext(OutputMessage outputItem) {
            try {
                ((CompletableFuture)PythonService.this.futureQueue.remove()).complete(outputItem.getOutputValueList());
            }
            catch (Throwable e) {
                PythonService.this.exceptionInOutputObserver = e;
                PythonService.this.completionLatch.countDown();
            }
        }

        @Override
        public void onError(Throwable e) {
            try {
                CompletableFuture future;
                e = GrpcUtil.translateGrpcException(e);
                PythonService.this.exceptionInOutputObserver = e;
                while ((future = (CompletableFuture)PythonService.this.futureQueue.poll()) != null) {
                    future.completeExceptionally(e);
                }
            }
            finally {
                PythonService.this.completionLatch.countDown();
            }
        }

        @Override
        public void onCompleted() {
            CompletableFuture future;
            while ((future = (CompletableFuture)PythonService.this.futureQueue.poll()) != null) {
                future.completeExceptionally((Throwable)new JetException("Completion signaled before the future was completed"));
            }
            PythonService.this.completionLatch.countDown();
        }
    }
}

