/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.grpc.impl;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.grpc.GrpcProperties;
import com.hazelcast.jet.grpc.GrpcService;
import com.hazelcast.jet.grpc.impl.GrpcUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public final class UnaryService<T, R>
implements GrpcService<T, R> {
    private final BiConsumerEx<? super T, ? super StreamObserver<R>> callFn;
    private final ManagedChannel channel;
    private final ILogger logger;
    private final long shutdownTimeout;

    public UnaryService(@Nonnull Processor.Context context, @Nonnull ManagedChannel channel, @Nonnull FunctionEx<? super ManagedChannel, ? extends BiConsumerEx<T, StreamObserver<R>>> callStubFn) {
        this.logger = context.logger();
        this.channel = channel;
        this.callFn = (BiConsumerEx)callStubFn.apply((Object)channel);
        Properties properties = context.hazelcastInstance().getConfig().getProperties();
        HazelcastProperties hzProperties = new HazelcastProperties(properties);
        this.shutdownTimeout = hzProperties.getSeconds(GrpcProperties.SHUTDOWN_TIMEOUT);
    }

    @Override
    @Nonnull
    public CompletableFuture<R> call(@Nonnull T input) {
        Observer o = new Observer();
        this.callFn.accept(input, o);
        return o.future;
    }

    public void destroy() throws InterruptedException {
        GrpcUtil.shutdownChannel(this.channel, this.logger, this.shutdownTimeout);
    }

    private static class Observer<R>
    implements StreamObserver<R> {
        private final CompletableFuture<R> future = new CompletableFuture();
        private R value;

        Observer() {
        }

        @Override
        public void onNext(R value) {
            assert (this.value == null) : "value should not be assigned twice in unary mode";
            this.value = value;
        }

        @Override
        public void onError(Throwable t2) {
            this.future.completeExceptionally(GrpcUtil.translateGrpcException(t2));
        }

        @Override
        public void onCompleted() {
            this.future.complete(this.value);
        }
    }
}

