/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PlainTextThreadDumpFormatter {
    private PlainTextThreadDumpFormatter() {
    }

    public static String format(ThreadInfo[] threads) {
        StringWriter dump = new StringWriter();
        PrintWriter writer = new PrintWriter(dump);
        for (ThreadInfo info : threads) {
            PlainTextThreadDumpFormatter.writeThread((PrintWriter)writer, (ThreadInfo)info);
        }
        return dump.toString();
    }

    private static void writeThread(PrintWriter writer, ThreadInfo info) {
        writer.printf("\"%s\" - Thread t@%d%n", info.getThreadName(), info.getThreadId());
        writer.printf("   %s: %s%n", new Object[]{Thread.State.class.getCanonicalName(), info.getThreadState()});
        PlainTextThreadDumpFormatter.writeStackTrace((PrintWriter)writer, (ThreadInfo)info, (MonitorInfo[])info.getLockedMonitors());
        writer.println();
        PlainTextThreadDumpFormatter.writeLockedOwnableSynchronizers((PrintWriter)writer, (ThreadInfo)info);
        writer.println();
    }

    private static void writeStackTrace(PrintWriter writer, ThreadInfo info, MonitorInfo[] lockedMonitors) {
        int depth = 0;
        for (StackTraceElement element : info.getStackTrace()) {
            PlainTextThreadDumpFormatter.writeStackTraceElement((PrintWriter)writer, (StackTraceElement)element, (ThreadInfo)info, (List)PlainTextThreadDumpFormatter.lockedMonitorsForDepth((MonitorInfo[])lockedMonitors, (int)depth), (depth == 0 ? 1 : 0) != 0);
            ++depth;
        }
    }

    private static List<MonitorInfo> lockedMonitorsForDepth(MonitorInfo[] lockedMonitors, int depth) {
        return Stream.of(lockedMonitors).filter(lockedMonitor -> lockedMonitor.getLockedStackDepth() == depth).collect(Collectors.toList());
    }

    private static void writeStackTraceElement(PrintWriter writer, StackTraceElement element, ThreadInfo info, List<MonitorInfo> lockedMonitors, boolean firstElement) {
        writer.printf("\tat %s%n", element.toString());
        LockInfo lockInfo = info.getLockInfo();
        if (firstElement && lockInfo != null) {
            if (element.getClassName().equals(Object.class.getName()) && element.getMethodName().equals("wait")) {
                writer.printf("\t- waiting on %s%n", PlainTextThreadDumpFormatter.format((LockInfo)lockInfo));
            } else {
                String lockOwner = info.getLockOwnerName();
                if (lockOwner != null) {
                    writer.printf("\t- waiting to lock %s owned by \"%s\" t@%d%n", PlainTextThreadDumpFormatter.format((LockInfo)lockInfo), lockOwner, info.getLockOwnerId());
                } else {
                    writer.printf("\t- parking to wait for %s%n", PlainTextThreadDumpFormatter.format((LockInfo)lockInfo));
                }
            }
        }
        PlainTextThreadDumpFormatter.writeMonitors((PrintWriter)writer, lockedMonitors);
    }

    private static String format(LockInfo lockInfo) {
        return String.format("<%x> (a %s)", lockInfo.getIdentityHashCode(), lockInfo.getClassName());
    }

    private static void writeMonitors(PrintWriter writer, List<MonitorInfo> lockedMonitorsAtCurrentDepth) {
        for (MonitorInfo lockedMonitor : lockedMonitorsAtCurrentDepth) {
            writer.printf("\t- locked %s%n", PlainTextThreadDumpFormatter.format((LockInfo)lockedMonitor));
        }
    }

    private static void writeLockedOwnableSynchronizers(PrintWriter writer, ThreadInfo info) {
        writer.println("   Locked ownable synchronizers:");
        LockInfo[] lockedSynchronizers = info.getLockedSynchronizers();
        if (lockedSynchronizers == null || lockedSynchronizers.length == 0) {
            writer.println("\t- None");
        } else {
            for (LockInfo lockedSynchronizer : lockedSynchronizers) {
                writer.printf("\t- Locked %s%n", PlainTextThreadDumpFormatter.format((LockInfo)lockedSynchronizer));
            }
        }
    }
}

