/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.utils;

import com.hazelcast.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;

public final class CompletableFutureUtil {
    private CompletableFutureUtil() {
    }

    public static <T> Collection<T> returnWithDeadline(Collection<CompletableFuture<T>> futures, BiFunction<Integer, TimeoutException, T> timedOutResultFn, long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException {
        Preconditions.checkPositive((double)timeout, (String)"Timeout must be positive.");
        TimeoutException timeoutException = null;
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(timeout, timeUnit);
        }
        catch (TimeoutException e) {
            timeoutException = e;
        }
        int indx = 0;
        ArrayList<Object> results = new ArrayList<Object>(futures.size());
        for (CompletableFuture<CompletableFuture> completableFuture : futures) {
            if (completableFuture.isDone()) {
                results.add(completableFuture.join());
            } else {
                results.add(timedOutResultFn.apply(indx, timeoutException));
            }
            ++indx;
        }
        return results;
    }
}

