/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.wan;

import com.hazelcast.internal.management.events.EventMetadata;
import com.hazelcast.webmonitor.controller.dto.wan.WanEventsGroup;
import com.hazelcast.webmonitor.controller.dto.wan.WanSyncActionStatus;
import com.hazelcast.webmonitor.events.model.AbstractEvent;
import com.hazelcast.webmonitor.events.model.AbstractWanConfigurationEvent;
import com.hazelcast.webmonitor.events.model.AbstractWanEvent;
import com.hazelcast.webmonitor.events.model.AbstractWanMapEvent;
import com.hazelcast.webmonitor.events.model.EventDataHolder;
import com.hazelcast.webmonitor.events.model.WanConsistencyCheckFinishedEvent;
import com.hazelcast.webmonitor.events.model.WanSyncProgressEvent;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.wan.WanEventGroupFactory;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BinaryOperator;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

/*
 * Exception performing whole class analysis ignored.
 */
public final class WanEventGroupFactory {
    public static final String DONE_CHECK_SUMMARY_FORMAT = "%d out of %d partitions with %d map entries need to be synced across %d member(s)";
    public static final String DONE_SYNC_SUMMARY_FORMAT = "%d partitions in %d-%d seconds across %d member(s)";
    public static final String IN_PROGRESS_SYNC_SUMMARY_FORMAT = "%d partitions out of %d done across %d member(s)";
    public static final String WAN_CONFIGURATION_ADDED_SUMMARY = "WAN configuration added";
    public static final String WAN_CONFIGURATION_EXTENDED_SUMMARY = "WAN configuration extended";
    public static final String ERROR_SUMMARY = "Error";

    private WanEventGroupFactory() {
    }

    public static WanEventsGroup create(Map<MemberIdentifier, AbstractWanEvent> latestEventByMember) {
        AbstractWanEvent latestEvent = latestEventByMember.values().stream().reduce(BinaryOperator.maxBy(Comparator.comparing(AbstractEvent::getTimestamp))).orElseThrow(IllegalStateException::new);
        WanEventsGroup.Type type = WanEventGroupFactory.extractType((AbstractWanEvent)latestEvent);
        WanSyncActionStatus status = WanEventGroupFactory.extractStatus(latestEventByMember);
        String summary = WanEventGroupFactory.extractSummary((WanEventsGroup.Type)type, (WanSyncActionStatus)status, latestEventByMember);
        return WanEventsGroup.builder().timestamp(latestEvent.getTimestamp()).uuid(latestEvent.getUuid()).endpoint(WanEventGroupFactory.extractEndpoint((AbstractWanEvent)latestEvent)).target(WanEventGroupFactory.extractTarget((AbstractWanEvent)latestEvent)).map(WanEventGroupFactory.extractMap((AbstractWanEvent)latestEvent)).type(type).status(status).summary(summary).build();
    }

    private static String extractEndpoint(AbstractWanEvent lastEvent) {
        EventMetadata.EventType eventType = lastEvent.getType();
        switch (1.$SwitchMap$com$hazelcast$internal$management$events$EventMetadata$EventType[eventType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return ((AbstractWanConfigurationEvent)lastEvent).getWanConfigName();
            }
        }
        return ((AbstractWanMapEvent)lastEvent).getReplicationName();
    }

    private static String extractTarget(AbstractWanEvent event) {
        if (event instanceof AbstractWanMapEvent) {
            return ((AbstractWanMapEvent)event).getPublisherId();
        }
        return null;
    }

    private static String extractMap(AbstractWanEvent event) {
        if (event instanceof AbstractWanMapEvent) {
            return ((AbstractWanMapEvent)event).getMapName();
        }
        return null;
    }

    private static WanEventsGroup.Type extractType(AbstractWanEvent event) {
        EventMetadata.EventType type = event.getType();
        switch (1.$SwitchMap$com$hazelcast$internal$management$events$EventMetadata$EventType[type.ordinal()]) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return WanEventsGroup.Type.SYNC;
            }
            case 9: 
            case 10: 
            case 11: {
                return WanEventsGroup.Type.CHECK;
            }
            case 1: 
            case 2: 
            case 3: {
                return WanEventsGroup.Type.CONFIG;
            }
        }
        throw new IllegalArgumentException("Unknown event type " + type);
    }

    private static WanSyncActionStatus extractStatus(Map<MemberIdentifier, AbstractWanEvent> latestEventByMember) {
        WanSyncActionStatus.Status status = WanSyncActionStatus.Status.DONE;
        int current = 0;
        int total = 0;
        for (AbstractWanEvent event : latestEventByMember.values()) {
            Pair data = WanEventGroupFactory.extractStatus((AbstractWanEvent)event);
            if (data.getLeft() == WanSyncActionStatus.Status.ERROR) {
                return WanSyncActionStatus.error();
            }
            if (status == WanSyncActionStatus.Status.DONE && data.getLeft() == WanSyncActionStatus.Status.DONE) continue;
            status = WanSyncActionStatus.Status.IN_PROGRESS;
            current += ((Integer)((Pair)data.getRight()).getLeft()).intValue();
            total += ((Integer)((Pair)data.getRight()).getRight()).intValue();
        }
        if (status == WanSyncActionStatus.Status.DONE) {
            return WanSyncActionStatus.done();
        }
        int progress = total == 0 ? 0 : current * 100 / total;
        return WanSyncActionStatus.inProgress((int)progress);
    }

    private static Pair<WanSyncActionStatus.Status, Pair<Integer, Integer>> extractStatus(AbstractWanEvent lastEvent) {
        EventMetadata.EventType eventType = lastEvent.getType();
        switch (1.$SwitchMap$com$hazelcast$internal$management$events$EventMetadata$EventType[eventType.ordinal()]) {
            case 4: 
            case 7: {
                EventDataHolder.SyncFinishedTrait finishEvent = (EventDataHolder.SyncFinishedTrait)lastEvent;
                return Pair.of((Object)WanSyncActionStatus.Status.DONE, (Object)Pair.of((Object)finishEvent.getPartitionsSynced(), (Object)finishEvent.getPartitionsSynced()));
            }
            case 1: 
            case 2: 
            case 10: {
                return Pair.of((Object)WanSyncActionStatus.Status.DONE, (Object)Pair.of((Object)0, (Object)0));
            }
            case 3: 
            case 8: 
            case 11: {
                return Pair.of((Object)WanSyncActionStatus.Status.ERROR, null);
            }
            case 5: 
            case 9: {
                return Pair.of((Object)WanSyncActionStatus.Status.IN_PROGRESS, (Object)Pair.of((Object)0, (Object)0));
            }
            case 6: {
                WanSyncProgressEvent progressEvent = (WanSyncProgressEvent)lastEvent;
                int syncedPartitions = progressEvent.getPartitionsSynced();
                int partitionsToSync = progressEvent.getPartitionsToSync();
                return Pair.of((Object)WanSyncActionStatus.Status.IN_PROGRESS, (Object)Pair.of((Object)syncedPartitions, (Object)partitionsToSync));
            }
        }
        throw new IllegalArgumentException("Unknown event type " + eventType);
    }

    private static String extractSummary(WanEventsGroup.Type type, WanSyncActionStatus status, Map<MemberIdentifier, AbstractWanEvent> latestEventByMember) {
        if (status.getStatus() == WanSyncActionStatus.Status.ERROR) {
            return "Error";
        }
        if (status.getStatus() == WanSyncActionStatus.Status.DONE) {
            if (type == WanEventsGroup.Type.CONFIG) {
                return latestEventByMember.values().stream().findFirst().map(WanEventGroupFactory::extractConfigSummary).orElse("");
            }
            if (type == WanEventsGroup.Type.CHECK) {
                Triple totals = latestEventByMember.values().stream().map(WanConsistencyCheckFinishedEvent.class::cast).map(event -> Triple.of((Object)event.getDiffCount(), (Object)event.getCheckedCount(), (Object)event.getEntriesToSync())).reduce(Triple.of((Object)0, (Object)0, (Object)0), (a, b) -> Triple.of((Object)((Integer)a.getLeft() + (Integer)b.getLeft()), (Object)((Integer)a.getMiddle() + (Integer)b.getMiddle()), (Object)((Integer)a.getRight() + (Integer)b.getRight())));
                return String.format("%d out of %d partitions with %d map entries need to be synced across %d member(s)", totals.getLeft(), totals.getMiddle(), totals.getRight(), latestEventByMember.size());
            }
            if (type == WanEventsGroup.Type.SYNC) {
                Triple totals = latestEventByMember.values().stream().map(EventDataHolder.SyncFinishedTrait.class::cast).map(event -> Triple.of((Object)event.getPartitionsSynced(), (Object)event.getDurationSeconds(), (Object)event.getDurationSeconds())).reduce(Triple.of((Object)0, (Object)Integer.MAX_VALUE, (Object)0), (a, b) -> Triple.of((Object)((Integer)a.getLeft() + (Integer)b.getLeft()), (Object)Math.min((Integer)a.getMiddle(), (Integer)b.getMiddle()), (Object)Math.max((Integer)a.getRight(), (Integer)b.getRight())));
                return String.format("%d partitions in %d-%d seconds across %d member(s)", totals.getLeft(), totals.getMiddle(), totals.getRight(), latestEventByMember.size());
            }
        }
        if (status.getStatus() == WanSyncActionStatus.Status.IN_PROGRESS) {
            if (type == WanEventsGroup.Type.CHECK) {
                return status.getProgress() + "%";
            }
            if (type == WanEventsGroup.Type.SYNC) {
                Pair totals = latestEventByMember.values().stream().map(WanEventGroupFactory::extractPartitionsSyncData).reduce(Pair.of((Object)0, (Object)0), (a, b) -> Pair.of((Object)((Integer)a.getLeft() + (Integer)b.getLeft()), (Object)((Integer)a.getRight() + (Integer)b.getRight())));
                return String.format("%d partitions out of %d done across %d member(s)", totals.getLeft(), totals.getRight(), latestEventByMember.size());
            }
        }
        throw new IllegalStateException();
    }

    private static Pair<Integer, Integer> extractPartitionsSyncData(AbstractWanEvent event) {
        switch (1.$SwitchMap$com$hazelcast$internal$management$events$EventMetadata$EventType[event.getType().ordinal()]) {
            case 4: 
            case 7: {
                EventDataHolder.SyncFinishedTrait finished = (EventDataHolder.SyncFinishedTrait)event;
                return Pair.of((Object)finished.getPartitionsSynced(), (Object)finished.getPartitionsSynced());
            }
            case 6: {
                WanSyncProgressEvent progressEvent = (WanSyncProgressEvent)event;
                return Pair.of((Object)progressEvent.getPartitionsSynced(), (Object)progressEvent.getPartitionsToSync());
            }
        }
        return Pair.of((Object)0, (Object)0);
    }

    private static String extractConfigSummary(AbstractWanEvent event) {
        switch (1.$SwitchMap$com$hazelcast$internal$management$events$EventMetadata$EventType[event.getType().ordinal()]) {
            case 1: {
                return "WAN configuration added";
            }
            case 2: {
                return "WAN configuration extended";
            }
        }
        return event.getType().toString();
    }
}

