/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.blueconic.browscap.Capabilities;
import com.blueconic.browscap.UserAgentParser;
import com.hazelcast.webmonitor.model.telemetry.UserLoginEvent;
import com.hazelcast.webmonitor.model.telemetry.UserLoginRequestRawData;
import com.hazelcast.webmonitor.service.telemetry.UserLoginEventStore;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserLoginEventStoreImpl
implements UserLoginEventStore {
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private Set<UserLoginEvent> events = ConcurrentHashMap.newKeySet();
    private final UserAgentParser userAgentParser;

    UserLoginEventStoreImpl(UserAgentParser userAgentParser) {
        this.userAgentParser = userAgentParser;
    }

    public void userLoggedIn(UserLoginRequestRawData userLoginData) {
        Integer screenHeight = UserLoginEventStoreImpl.getIntOrNull((UserLoginRequestRawData)userLoginData, (String)"screenHeight");
        Integer screenWidth = UserLoginEventStoreImpl.getIntOrNull((UserLoginRequestRawData)userLoginData, (String)"screenWidth");
        Integer windowHeight = UserLoginEventStoreImpl.getIntOrNull((UserLoginRequestRawData)userLoginData, (String)"windowHeight");
        Integer windowWidth = UserLoginEventStoreImpl.getIntOrNull((UserLoginRequestRawData)userLoginData, (String)"windowWidth");
        if (this.userAgentParser == null) {
            this.store(new UserLoginEvent(screenHeight, screenWidth, windowHeight, windowWidth));
        } else {
            Capabilities capabilities = this.userAgentParser.parse((String)userLoginData.getHeaders().get("User-Agent"));
            String browser = capabilities.getBrowser();
            String browserMajorVersion = capabilities.getBrowserMajorVersion();
            String platform = capabilities.getPlatform();
            String platformVersion = capabilities.getPlatformVersion();
            this.store(new UserLoginEvent(browser, browserMajorVersion, platform, platformVersion, screenHeight, screenWidth, windowHeight, windowWidth));
        }
    }

    public Set<UserLoginEvent> drain() {
        Set result;
        this.writeLock.lock();
        try {
            result = this.events;
            this.events = ConcurrentHashMap.newKeySet();
        }
        finally {
            this.writeLock.unlock();
        }
        return result;
    }

    private static Integer getIntOrNull(UserLoginRequestRawData request, String parameterName) {
        String[] params = (String[])request.getParameters().get(parameterName);
        if (params == null || params.length == 0) {
            return null;
        }
        try {
            return Integer.parseInt(params[0]);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void store(UserLoginEvent event) {
        this.readLock.lock();
        try {
            this.events.add(event);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int loginEventsCount() {
        return this.events.size();
    }
}

