/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.metrics;

import com.hazelcast.webmonitor.controller.dto.metrics.MetricDTO;
import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.MetricsStorage;
import com.hazelcast.webmonitor.metrics.imdg.ImdgQueryBuilder;
import com.hazelcast.webmonitor.service.metrics.Aggregation;
import com.hazelcast.webmonitor.service.metrics.DiffPerSecondAggregator;
import java.util.Optional;

final class PlainAggregation
implements Aggregation {
    private final MetricsStorage storage;

    PlainAggregation(MetricsStorage storage) {
        this.storage = storage;
    }

    public DataPointSeries range(ImdgQueryBuilder queryBuilder, MetricDTO.Aggregate aggregate) {
        DataPointSeries series = this.storage.queryRange(queryBuilder.build());
        if (aggregate != null) {
            series = this.diffPerSec(series, aggregate);
        }
        return series;
    }

    public Optional<DataPointAware> latest(ImdgQueryBuilder queryBuilder, MetricDTO.Aggregate aggregate) {
        Optional point;
        if (aggregate != null) {
            DataPointSeries series = this.storage.queryRange(queryBuilder.build());
            series = this.diffPerSec(series, aggregate);
            point = series.getLatestDataPoint();
        } else {
            point = this.storage.queryLatest(queryBuilder.build());
        }
        return point;
    }

    private DataPointSeries diffPerSec(DataPointSeries origin, MetricDTO.Aggregate aggregate) {
        if (aggregate != MetricDTO.Aggregate.DIFF_PER_SEC) {
            throw new IllegalArgumentException("[" + aggregate + "] aggregate is not supported without GroupBy");
        }
        return new DiffPerSecondAggregator(origin).compute();
    }
}

