/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.metrics;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.metrics.MetricConsumer;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.diagnostics.Diagnostics;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.ScheduledOperationChainRegistry;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.jet.JetMetricsService;
import com.hazelcast.webmonitor.service.metrics.DataPointsReceivedEvent;
import com.hazelcast.webmonitor.service.metrics.MetricsConsumer;
import com.hazelcast.webmonitor.service.metrics.MetricsService;
import com.hazelcast.webmonitor.service.metrics.MetricsTraceLogger;
import com.hazelcast.webmonitor.utils.ExceptionUtil;
import com.hazelcast.webmonitor.utils.MemberUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;

/*
 * Exception performing whole class analysis ignored.
 */
public class MetricsConsumer
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsConsumer.class);
    private final ScheduledExecutorService executorService;
    private final ScheduledOperationChainRegistry<Member> chainIdRegistry = new ScheduledOperationChainRegistry();
    private final MetricsService metricsService;
    private final JetMetricsService jetMetricsService;
    private final ApplicationEventPublisher publisher;
    private final ClusterManager clusterManager;
    private final MCClientManager mcClientManager;
    private final LicenseManager licenseManager;
    private final MetricsConfigurationProperties properties;
    private final MetricsTraceLogger metricsTraceLogger;

    public MetricsConsumer(MetricsService metricsService, JetMetricsService jetMetricsService, ApplicationEventPublisher publisher, ClusterManager clusterManager, MCClientManager mcClientManager, LicenseManager licenseManager, MetricsConfigurationProperties properties, MetricsTraceLogger metricsTraceLogger) {
        this.metricsService = metricsService;
        this.jetMetricsService = jetMetricsService;
        this.publisher = publisher;
        this.clusterManager = clusterManager;
        this.mcClientManager = mcClientManager;
        this.licenseManager = licenseManager;
        this.properties = properties;
        this.metricsTraceLogger = metricsTraceLogger;
        this.executorService = Executors.newScheduledThreadPool(properties.getConsumerThreadPoolSize(), new ThreadFactoryBuilder().setNameFormat("MetricsConsumer-%d").build());
    }

    @EventListener
    public void onMemberJoined(MembersJoinedEvent event) {
        MCClient client = this.mcClientManager.clientFor(event.getCluster());
        event.getMembers().forEach(member -> this.scheduleReadMetrics(this.chainIdRegistry.nextId(member), client, member, 0L, Duration.ZERO));
    }

    private void readMetrics(int chainId, MCClient client, Member member, long seq) {
        if (!this.chainIdRegistry.sameAsCurrentId((Object)member, chainId)) {
            return;
        }
        int numberOfMembers = client.getHzClient().getCluster().getMembers().size();
        if (this.licenseManager.isAboveMemberLimit(numberOfMembers)) {
            this.scheduleReadMetrics(chainId, client, member, seq, this.properties.getConsumerRescheduleOnErrorDelay());
            return;
        }
        client.readMetricsAsync(member, seq).whenCompleteAsync((resultSet, t) -> {
            String cluster = client.getClusterName();
            if (t == null) {
                this.scheduleReadMetrics(chainId, client, member, resultSet.nextSequence(), this.properties.getConsumerRescheduleDelay());
                this.extractAndSaveMetrics(cluster, member, resultSet.collections());
            } else {
                Throwable error = ExceptionUtil.peelClientError((Throwable)t);
                log.debug("Exception when requesting metrics from {} of cluster {}.", new Object[]{member, cluster, error});
                if (ExceptionUtil.isRecoverableClientError((Throwable)error)) {
                    this.scheduleReadMetrics(chainId, client, member, seq, this.properties.getConsumerRescheduleOnErrorDelay());
                    return;
                }
                this.chainIdRegistry.cleanUp((Object)member, chainId);
                log.error("Error reading metrics for {} from cluster {}. Stopped metrics collection for this member.", new Object[]{member, cluster, t});
            }
        }, (Executor)this.executorService);
    }

    private void scheduleReadMetrics(int chainId, MCClient client, Member member, long seq, Duration delay) {
        this.executorService.schedule(() -> {
            try {
                this.readMetrics(chainId, client, member, seq);
            }
            catch (Exception e) {
                log.error("Error reading metrics from {} of cluster {}.", new Object[]{member, client.getClusterName(), e});
            }
        }, delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractAndSaveMetrics(String cluster, Member member, List<Map.Entry<Long, byte[]>> collections) {
        Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - extracting metric collections", (Object)member);
        String memberAddress = MemberUtil.getMemberAddress((Member)member);
        List metricDataPoints = collections.stream().flatMap(collection -> {
            Long time = (Long)collection.getKey();
            MetricsCollector metricsCollector = new MetricsCollector(time.longValue(), cluster, memberAddress, this.properties.isConsumerLargeClusterMode());
            MetricsCompressor.extractMetrics((byte[])((byte[])collection.getValue()), (MetricConsumer)metricsCollector);
            this.metricsTraceLogger.trace(MetricsCollector.access$000((MetricsCollector)metricsCollector), "Metric extracted to be saved");
            return metricsCollector.stream();
        }).collect(Collectors.toList());
        Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - extracted {} metric data points", (Object)member, (Object)metricDataPoints.size());
        MemberIdentifier memberIdent = MemberIdentifier.of((String)cluster, (String)memberAddress);
        this.publisher.publishEvent((ApplicationEvent)new DataPointsReceivedEvent(memberIdent, metricDataPoints));
        this.metricsTraceLogger.trace(metricDataPoints, "Metric published");
        if (this.clusterManager.isJetEnabled(cluster)) {
            try {
                Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - saving received data points for jet", (Object)member);
                this.jetMetricsService.save(cluster, member, metricDataPoints);
                this.metricsTraceLogger.trace(metricDataPoints, "Metric saved");
            }
            catch (Exception e) {
                log.error("Could not process Jet metrics from {} of cluster {}.", new Object[]{member, cluster, e});
            }
            finally {
                Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - saved received data points for jet", (Object)member);
            }
        }
        try {
            Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - saving received data points", (Object)member);
            this.metricsService.save(metricDataPoints);
        }
        catch (Exception e) {
            log.error("Could not process metrics from {} of cluster {}.", new Object[]{member, cluster, e});
        }
        finally {
            Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - saved received data points", (Object)member);
        }
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }
}

