/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.memberconfig;

import com.hazelcast.config.Config;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.webmonitor.service.memberconfig.ParsedEventJournalConfig;
import com.hazelcast.webmonitor.service.memberconfig.ParsedMemberConfig;
import javax.annotation.Nonnull;

public class ConfigXmlParser {
    private final Config config;

    public ConfigXmlParser(@Nonnull Config config) {
        this.config = config;
    }

    public ParsedMemberConfig parse() {
        ParsedMemberConfig result = new ParsedMemberConfig();
        result.setSecurityEnabled(this.config.getSecurityConfig().isEnabled());
        result.setJetEnabled(this.config.getJetConfig().isEnabled());
        result.setCpMemberCount(this.config.getCPSubsystemConfig().getCPMemberCount());
        NativeMemoryConfig nativeMemoryConfig = this.config.getNativeMemoryConfig();
        result.setUsesOptaneMemory(nativeMemoryConfig.isEnabled() && !this.config.getNativeMemoryConfig().getPersistentMemoryConfig().getDirectoryConfigs().isEmpty());
        this.config.getMapConfigs().forEach((name, map) -> {
            EventJournalConfig eventJournalConfig = map.getEventJournalConfig();
            if (eventJournalConfig.isEnabled()) {
                result.addEventJournalConfig(name, new ParsedEventJournalConfig((long)eventJournalConfig.getCapacity(), (long)eventJournalConfig.getTimeToLiveSeconds()));
            }
        });
        result.setLicenseKey(this.config.getLicenseKey());
        return result;
    }
}

