/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.MemberStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.MemberMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class MemberMXBeanImpl
implements MemberMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "Members";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String address;
    private volatile MemberStatsDTO stats;

    public MemberMXBeanImpl(ClusteredStatsService statsService, String cluster, String address) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.address = address;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        TimedMemberState timedMemberState = (TimedMemberState)state.getTimedMemberStates().get(this.address);
        if (timedMemberState == null) {
            return;
        }
        this.stats = this.statsService.getMemberStats(this.cluster, this.address, timedMemberState);
    }

    public String getName() {
        return this.address;
    }

    public String getAddress() {
        return this.address;
    }

    public String getUuid() {
        return (String)MXBeanHelper.safeGet((Object)this.stats, MemberStatsDTO::getUuid, (Object)"");
    }

    public String getCpMemberUuid() {
        return (String)MXBeanHelper.safeGet((Object)this.stats, MemberStatsDTO::getCpMemberUuid, (Object)"");
    }

    public long getMaxHeapMemory() {
        return MXBeanHelper.safeGet((Object)this.stats, MemberStatsDTO::getMaxHeapMemory);
    }

    public long getUsedHeapMemory() {
        return MXBeanHelper.safeGet((Object)this.stats, MemberStatsDTO::getUsedHeapMemory);
    }

    public long getFreeHeapMemory() {
        return MXBeanHelper.safeGet((Object)this.stats, MemberStatsDTO::getFreeHeapMemory);
    }

    public long getCommittedHeapMemory() {
        return MXBeanHelper.safeGet((Object)this.stats, MemberStatsDTO::getCommittedHeapMemory);
    }

    public long getMaxNativeMemory() {
        return MXBeanHelper.safeGet((Object)this.stats, MemberStatsDTO::getMaxNativeMemory);
    }

    public long getCommittedNativeMemory() {
        return MXBeanHelper.safeGet((Object)this.stats, MemberStatsDTO::getCommittedNativeMemory);
    }

    public long getUsedNativeMemory() {
        return MXBeanHelper.safeGet((Object)this.stats, MemberStatsDTO::getUsedNativeMemory);
    }

    public long getFreeNativeMemory() {
        return MXBeanHelper.safeGet((Object)this.stats, MemberStatsDTO::getFreeNativeMemory);
    }

    public long getOwnedPartitionCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MemberStatsDTO::getOwnedPartitionCount);
    }

    public int getConnectedClientCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MemberStatsDTO::getConnectedClientCount);
    }

    public boolean isMaster() {
        return this.stats != null && this.stats.isMaster();
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.cluster, (String)TYPE_NAME, (String)this.getName());
    }
}

