/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jet;

import com.hazelcast.webmonitor.controller.dto.jet.EdgeInfoDTO;
import com.hazelcast.webmonitor.metrics.jet.JetClusterMetricsStore;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpression;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpressions;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeries;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.jet.BaseJetManager;
import com.hazelcast.webmonitor.service.jet.JetMetricsService;
import org.springframework.stereotype.Service;

@Service
class EdgeLookup
extends BaseJetManager {
    EdgeLookup(MCClientManager clientManager, JetMetricsService jetMetricsService, Clock clock) {
        super(clientManager, jetMetricsService, clock);
    }

    EdgeInfoDTO lookUpEdgeInfo(String cluster, String jobId, String sourceVertex, int fromOrdinal, String targetVertex, int toOrdinal) {
        BaseJetManager.JobIdentifier job = new BaseJetManager.JobIdentifier(cluster, jobId);
        JetClusterMetricsStore store = this.jetMetricsService.getStore(job.cluster);
        String lastExecutionId = this.getLastExecutionId(job);
        long totalRecordsFlow = store.query("emittedCount", (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)job.idString), TagExpressions.tagEquals((String)"vertex", (String)sourceVertex), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId), TagExpressions.tagEquals((String)"ordinal", (String)String.valueOf(fromOrdinal))})).mapToLong(TimeSeries::queryLast).sum();
        long end = this.clock.currentTimeMillis();
        long lastMinRecordsFlow = totalRecordsFlow - store.query("emittedCount", (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)job.idString), TagExpressions.tagEquals((String)"vertex", (String)sourceVertex), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId), TagExpressions.tagEquals((String)"ordinal", (String)String.valueOf(fromOrdinal))})).mapToLong(ts -> ts.query(end - 60000L, 0L)).sum();
        return EdgeInfoDTO.builder().jobId(job.idString).sourceVertex(sourceVertex).fromOrdinal(fromOrdinal).targetVertex(targetVertex).toOrdinal(toOrdinal).totalRecordsFlow(totalRecordsFlow).lastMinRecordsFlow(lastMinRecordsFlow).build();
    }
}

