/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SemanticConfigAnalyzer;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class MapNativeMemoryEvictionAnalyzer
extends SemanticConfigAnalyzer {
    private static final List<MaxSizePolicy> INVALID_MAX_SIZE_POLICIES = Collections.unmodifiableList(Arrays.asList(MaxSizePolicy.FREE_HEAP_PERCENTAGE, MaxSizePolicy.FREE_HEAP_SIZE, MaxSizePolicy.USED_HEAP_PERCENTAGE, MaxSizePolicy.USED_HEAP_SIZE));

    MapNativeMemoryEvictionAnalyzer(MemberConfigSupplier memberConfigs) {
        super(memberConfigs);
    }

    private Problem analyze(MapConfig mapConfig) {
        if (mapConfig.getInMemoryFormat() != InMemoryFormat.NATIVE) {
            return null;
        }
        EvictionConfig eviction = mapConfig.getEvictionConfig();
        if (eviction != null && INVALID_MAX_SIZE_POLICIES.contains(eviction.getMaxSizePolicy())) {
            return new ClusterWideProblem("NATIVE in-memory format does not work with eviction maximum size policy FREE_HEAP_PERCENTAGE as configured in " + mapConfig.getName(), "Choose an other in-memory format, or use one of the following maximum size policies: USED_NATIVE_MEMORY_SIZE, USED_NATIVE_MEMORY_PERCENTAGE, FREE_NATIVE_MEMORY_SIZE, FREE_NATIVE_MEMORY_PERCENTAGE, PER_NODE, PER_PARTITION, ENTRY_COUNT");
        }
        return null;
    }

    protected List<Problem> analyze(MemberConfig config) {
        return config.toEffectiveConfig().getMapConfigs().values().stream().map(arg_0 -> this.analyze(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String describeSelf() {
        return "Checking if Maps using native memory have proper eviction configurations";
    }
}

