/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AttributeEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.ListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MapListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import com.hazelcast.webmonitor.utils.InternalObjectsUtil;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class MapListEquivalence
extends ListEquivalence<Config, MapConfig, String> {
    MapListEquivalence(Map<MemberIdentifier, Config> memberConfigs) {
        super(memberConfigs, true);
    }

    AttributeEquivalence<MapConfig> createElementAttributeEquivalence(String elemId, Map<MapConfig, Set<MemberIdentifier>> groupsByValues) {
        return new MapAttributeEquivalence(this, elemId, groupsByValues);
    }

    MemberComparisonProblem createProblemForMissingElement(String elemId, Set<MemberIdentifier> membersMissingTheElem, Set<MemberIdentifier> membersContainingTheElem) {
        return MemberComparisonProblem.missingListElement((String)"map", (String)elemId, null, membersContainingTheElem, membersMissingTheElem);
    }

    MapConfig createDefaultElemForIdentifier(String mapName) {
        return new MapConfig().setName(mapName);
    }

    Config extractOwner(Config config) {
        return config;
    }

    Map<String, MapConfig> extractElements(Config owner) {
        return owner.getMapConfigs().entrySet().stream().filter(entry -> !InternalObjectsUtil.isInternalObject((String)((String)entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

