/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AttributeComparisonDispatcher;
import com.hazelcast.webmonitor.service.healthcheck.AttributeEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class ListEquivalence<O, E, EID> {
    protected final Map<MemberIdentifier, Config> memberConfigs;
    protected final List<Problem> problems = new ArrayList(1);

    ListEquivalence(Map<MemberIdentifier, Config> memberConfigs, boolean ignoreLiteMembers) {
        HashMap<MemberIdentifier, Config> effectiveMemberConfigs = new HashMap<MemberIdentifier, Config>(memberConfigs);
        if (ignoreLiteMembers) {
            effectiveMemberConfigs.entrySet().removeIf(entry -> ((Config)entry.getValue()).isLiteMember());
        }
        this.memberConfigs = effectiveMemberConfigs;
    }

    List<Problem> test() {
        Map values = this.separateValuesByElemId();
        Set allMembers = this.memberConfigs.keySet();
        for (Map.Entry e : values.entrySet()) {
            Object elemId = e.getKey();
            Map elemsByMember = (Map)e.getValue();
            if (elemsByMember.keySet().size() < allMembers.size()) {
                this.reportMissingProblem(allMembers, elemId, elemsByMember);
            }
            this.detectElementMismatches(elemId, elemsByMember);
        }
        this.problems.sort(Comparator.comparing(Problem::getDescription));
        return this.problems;
    }

    private void detectElementMismatches(EID elemId, Map<MemberIdentifier, E> objectsByMember) {
        List problems = AttributeComparisonDispatcher.dispatch(objectsByMember, membersByValues -> this.createElementAttributeEquivalence(elemId, membersByValues));
        this.problems.addAll(problems);
    }

    private void reportMissingProblem(Set<MemberIdentifier> allMembers, EID elemId, Map<MemberIdentifier, E> objectsByMember) {
        HashSet<MemberIdentifier> membersMissingTheElem = new HashSet<MemberIdentifier>(allMembers);
        membersMissingTheElem.removeAll(objectsByMember.keySet());
        Object defaultElem = this.createDefaultElemForIdentifier(elemId);
        boolean atLeastOneIsNonDefault = defaultElem == null ? true : objectsByMember.values().stream().anyMatch(elem -> !elem.equals(defaultElem));
        if (atLeastOneIsNonDefault) {
            Set<MemberIdentifier> membersContainingTheElem = objectsByMember.keySet();
            MemberComparisonProblem problem = this.createProblemForMissingElement(elemId, membersMissingTheElem, membersContainingTheElem);
            this.problems.add(problem);
        }
    }

    E createDefaultElemForIdentifier(EID elemId) {
        return null;
    }

    private Map<EID, Map<MemberIdentifier, E>> separateValuesByElemId() {
        HashMap<Object, Map> values = new HashMap<Object, Map>();
        for (Map.Entry memberConfigEntry : this.memberConfigs.entrySet()) {
            MemberIdentifier memberIdent = (MemberIdentifier)memberConfigEntry.getKey();
            Config memberConfig = (Config)memberConfigEntry.getValue();
            Object owner = this.extractOwner(memberConfig);
            Map objectsById = this.extractElements(owner);
            for (Map.Entry elemEntry : objectsById.entrySet()) {
                Object elemId = elemEntry.getKey();
                Object elem = elemEntry.getValue();
                values.computeIfAbsent(elemId, __ -> new HashMap()).put(memberIdent, elem);
            }
        }
        return values;
    }

    abstract AttributeEquivalence<E> createElementAttributeEquivalence(EID var1, Map<E, Set<MemberIdentifier>> var2);

    abstract MemberComparisonProblem createProblemForMissingElement(EID var1, Set<MemberIdentifier> var2, Set<MemberIdentifier> var3);

    abstract O extractOwner(Config var1);

    abstract Map<EID, E> extractElements(O var1);
}

