/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AttributeEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.JaasAuthenticationAttributeEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import com.hazelcast.webmonitor.service.healthcheck.OutlierGroup;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class JaasAuthenticationAttributeEquivalence
extends AttributeEquivalence<JaasAuthenticationConfig> {
    private final Map<MemberIdentifier, Config> memberConfigs;
    private final String realmName;
    private final LoginModuleListPool moduleListPool = new LoginModuleListPool();

    static String formatIndex(int index) {
        int lastTwoDigits;
        if (10 <= (lastTwoDigits = ++index % 100) && lastTwoDigits <= 20) {
            return index + "th";
        }
        int lastDigit = index % 10;
        if (lastDigit == 1) {
            return index + "st";
        }
        if (lastDigit == 2) {
            return index + "nd";
        }
        if (lastDigit == 3) {
            return index + "rd";
        }
        return index + "th";
    }

    JaasAuthenticationAttributeEquivalence(Map<JaasAuthenticationConfig, Set<MemberIdentifier>> groupsByValues, Map<MemberIdentifier, Config> memberConfigs, String realmName) {
        super(groupsByValues, "security realm " + realmName);
        this.memberConfigs = memberConfigs;
        this.realmName = realmName;
    }

    void compareEntries() {
        HashMap<Set, Object> moduleListsByMembers = new HashMap<Set, Object>();
        int longestListSize = 0;
        for (Map.Entry entry : this.groupsByValues.entrySet()) {
            JaasAuthenticationConfig jaasConfig = (JaasAuthenticationConfig)entry.getKey();
            LoginModuleList list = this.moduleListPool.createList(jaasConfig.getLoginModuleConfigs());
            longestListSize = Math.max(longestListSize, list.size());
            moduleListsByMembers.put((Set)entry.getValue(), list);
        }
        for (int i = 0; i < longestListSize; ++i) {
            HashMap<JaasLoginModule, Set> loginModulesAtIndex = new HashMap<JaasLoginModule, Set>(longestListSize);
            HashMap<String, Set> membersByClassName = new HashMap<String, Set>();
            for (Map.Entry entry : moduleListsByMembers.entrySet()) {
                Set members2 = (Set)entry.getKey();
                LoginModuleList loginModules = (LoginModuleList)entry.getValue();
                JaasLoginModule moduleAtIndex = (JaasLoginModule)loginModules.get(i);
                loginModulesAtIndex.put(moduleAtIndex, members2);
                membersByClassName.computeIfAbsent(JaasLoginModule.access$300((JaasLoginModule)moduleAtIndex), __ -> new HashSet()).addAll(members2);
            }
            if (membersByClassName.size() == 1) {
                String className2 = (String)membersByClassName.keySet().iterator().next();
                List list = new JaasLoginModuleAttributeEquivalence(this, loginModulesAtIndex, this.realmName, "the " + JaasAuthenticationAttributeEquivalence.formatIndex((int)i) + " login-module " + className2 + " in the jaas authentication of the " + this.ownerObjectDescription, i).test();
                if (list.isEmpty()) {
                    this.moduleListPool.allModulesMatchedAtIndex(i);
                }
                this.addProblems((Collection)list);
                continue;
            }
            MemberComparisonProblem.MemberComparisonProblemBuilder problemBuilder = MemberComparisonProblem.builder();
            problemBuilder.description("Different login-modules are configured at the " + JaasAuthenticationAttributeEquivalence.formatIndex((int)i) + " place of the login-module list in the jaas authentication of " + this.ownerObjectDescription).advice("Set the same login-module in all member configurations");
            membersByClassName.forEach((className, members) -> problemBuilder.addOutlierGroup(OutlierGroup.of((String)("Login-module is " + className), (Set)members)));
            this.addProblem((Problem)problemBuilder.build());
        }
    }

    static /* synthetic */ Map access$000(JaasAuthenticationAttributeEquivalence x0) {
        return x0.memberConfigs;
    }
}

