/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.healthcheck.MemberListDataSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class DefaultMemberListDataSource
implements MemberListDataSource {
    private final StateManager stateManager;

    public List<MemberIdentifier> get() {
        return this.stateManager.getClusterNames().stream().map(clusterName -> {
            AllState state = this.stateManager.getLatestState(clusterName);
            if (state != null) {
                SortedSet members = state.getMembers();
                return members.stream().map(member -> MemberIdentifier.of((String)clusterName, (String)member)).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"stateManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultMemberListDataSource(StateManager stateManager) {
        this.stateManager = stateManager;
    }
}

