/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.PermissionConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
final class ClientPermissionIdentifier {
    private static final String ANY_PRINCIPAL = "*";
    static final Collection<PermissionConfig.PermissionType> BASE_PERMISSION_TYPES = Collections.unmodifiableList(Arrays.asList(PermissionConfig.PermissionType.ALL, PermissionConfig.PermissionType.CONFIG, PermissionConfig.PermissionType.TRANSACTION, PermissionConfig.PermissionType.MANAGEMENT));
    private final PermissionConfig.PermissionType type;
    private final String instanceName;
    private final Set<String> principals;

    ClientPermissionIdentifier(PermissionConfig.PermissionType type, String instanceName, String rawPrincipal) {
        this.type = type;
        this.instanceName = instanceName;
        this.principals = ClientPermissionIdentifier.parsePrincipal((String)rawPrincipal);
    }

    static Set<String> parsePrincipal(String rawPrincipal) {
        if (rawPrincipal == null) {
            return Collections.singleton("*");
        }
        return new HashSet<String>(Arrays.asList(rawPrincipal.split(",")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientPermissionIdentifier)) {
            return false;
        }
        ClientPermissionIdentifier that = (ClientPermissionIdentifier)o;
        if (this.isBasePermissionType()) {
            return that.isBasePermissionType() && this.type == that.type;
        }
        return this.type == that.type && Objects.equals(this.instanceName, that.instanceName) && Objects.equals(this.principals, that.principals);
    }

    public int hashCode() {
        if (this.isBasePermissionType()) {
            return this.type.hashCode();
        }
        return Objects.hash(this.type, this.instanceName, this.principals);
    }

    private boolean isBasePermissionType() {
        return BASE_PERMISSION_TYPES.contains(this.type);
    }

    private boolean hasPrincipal() {
        return !this.principals.isEmpty() && !Collections.singleton("*").equals(this.principals);
    }

    public String toString() {
        String nodeName = this.type.getNodeName();
        if (this.isBasePermissionType()) {
            return nodeName;
        }
        if (nodeName.endsWith("-permission")) {
            String typeName = nodeName.substring(0, nodeName.lastIndexOf(45));
            StringBuilder sb = new StringBuilder(typeName).append(' ').append(this.instanceName);
            if (this.hasPrincipal()) {
                sb.append(" for principal ");
                sb.append(this.principals.stream().sorted().collect(Collectors.joining(",")));
            }
            return sb.toString();
        }
        throw new UnsupportedOperationException("unhandled node type " + nodeName);
    }

    boolean identifies(PermissionConfig config) {
        return this.type == config.getType() && (this.isBasePermissionType() || Objects.equals(config.getName(), this.instanceName) && Objects.equals(ClientPermissionIdentifier.parsePrincipal((String)config.getPrincipal()), this.principals));
    }
}

