/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcomeSource;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerFactory;
import com.hazelcast.webmonitor.service.healthcheck.CacheAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.ClientCountAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.DeviceCapacityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.DeviceUsageAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.IndexRedundancyAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.JetConfigAttributeEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.ManagementCenterConfigAttributeEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MapAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MapBackupReadEvictionAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MapCustomAttributeAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MapNativeMemoryEvictionAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MapQueryCacheConsistencyAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.NativeMemorySizeAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.OsMetricsAvailabilityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.PreconditionCheckingAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.QueueAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.ReliableTopicAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SecurityAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SerializationConfigEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.healthcheck.TopicAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.WanReplicationAttributeEquivalenceAnalyzer;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AnalyzerConfig {
    private final AnalyzerFactory analyzerFactory;

    public AnalyzerConfig(SourceDataSubscriptionPool sourceDataSubsPool) {
        this.analyzerFactory = new AnalyzerFactory(sourceDataSubsPool);
    }

    @Bean
    AnalysisOutcomeSource mapAnalyzer() {
        return new PreconditionCheckingAnalyzer(Collections.singletonList(this.mapAttributeEqualityAnalyzer()), Arrays.asList(this.backupReadEvictionAnalyzer(), this.customAttributeAnalyzer(), this.indexRedundancyAnalyzer(), this.nativeMemoryEvictionAnalyzer(), this.queryCacheConsistencyAnalyzer()));
    }

    Analyzer mapAttributeEqualityAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new MapAttributeEqualityAnalyzer(pool.subscribeToConfig()));
    }

    Analyzer backupReadEvictionAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new MapBackupReadEvictionAnalyzer(pool.subscribeToConfig()));
    }

    Analyzer customAttributeAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new MapCustomAttributeAnalyzer(pool.subscribeToConfig()));
    }

    Analyzer indexRedundancyAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new IndexRedundancyAnalyzer(pool.subscribeToConfig()));
    }

    Analyzer nativeMemoryEvictionAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new MapNativeMemoryEvictionAnalyzer(pool.subscribeToConfig()));
    }

    Analyzer queryCacheConsistencyAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new MapQueryCacheConsistencyAnalyzer(pool.subscribeToConfig()));
    }

    @Bean
    Analyzer cacheAttributeEquivalenceAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new CacheAttributeEqualityAnalyzer(pool.subscribeToConfig()));
    }

    @Bean
    Analyzer serializationAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new SerializationConfigEqualityAnalyzer(pool.subscribeToConfig()));
    }

    @Bean
    Analyzer securityAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new SecurityAttributeEqualityAnalyzer(pool.subscribeToConfig()));
    }

    @Bean
    Analyzer queueConfigAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new QueueAttributeEqualityAnalyzer(pool.subscribeToConfig()));
    }

    @Bean
    Analyzer topicConfigAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new TopicAttributeEqualityAnalyzer(pool.subscribeToConfig()));
    }

    @Bean
    Analyzer reliableTopicConfigAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new ReliableTopicAttributeEqualityAnalyzer(pool.subscribeToConfig()));
    }

    @Bean
    Analyzer wanReplicationConfigAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new WanReplicationAttributeEquivalenceAnalyzer(pool.subscribeToConfig()));
    }

    @Bean
    Analyzer jetConfigAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new JetConfigAttributeEquivalence(pool.subscribeToConfig()));
    }

    @Bean
    Analyzer managementCenterConfigAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new ManagementCenterConfigAttributeEquivalence(pool.subscribeToConfig()));
    }

    @Bean
    Analyzer osMetricsAvailabilityAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new OsMetricsAvailabilityAnalyzer(pool.subscribeToMetric("os.freePhysicalMemorySize")));
    }

    @Bean
    Analyzer deviceCapacityAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new DeviceCapacityAnalyzer(pool.subscribeToConfig(), pool.subscribeToMetric("tstore.device.maxSpace")));
    }

    @Bean
    Analyzer deviceUsageAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new DeviceUsageAnalyzer(pool.subscribeToConfig(), pool.subscribeToMetric("tstore.device.usage")));
    }

    @Bean
    Analyzer nativeMemorySizeAnalyzer() {
        return this.analyzerFactory.wrapAnalyzer(pool -> new NativeMemorySizeAnalyzer(pool.subscribeToConfig(), pool.subscribeToMetric("memory.usedNative")));
    }

    @Bean
    Analyzer clientCountAnalyzer(StateManager stateManager) {
        return this.analyzerFactory.wrapAnalyzer(pool -> new ClientCountAnalyzer(stateManager));
    }
}

