/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.client_filtering;

import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringListWithEntriesDTO;
import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.service.ClusterClientFilteringDTO;
import com.hazelcast.webmonitor.service.ConnectedToClusterEvent;
import com.hazelcast.webmonitor.service.ScheduledOperationChainRegistry;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringService;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringSharedSource;
import com.hazelcast.webmonitor.service.client_filtering.ClusterLockManager;
import com.hazelcast.webmonitor.service.client_filtering.LoggingReadWriteLock;
import com.hazelcast.webmonitor.utils.ExceptionUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ClientFilteringSynchronizer
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientFilteringSynchronizer.class);
    private static final long DEFAULT_RESCHEDULE_DELAY_MS = 1000L;
    private static final long DEFAULT_RESCHEDULE_ON_ERROR_DELAY_MS = 5000L;
    private final ClientFilteringService clientFilteringService;
    private final long rescheduleDelayMs;
    private final long rescheduleOnErrorDelayMs;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, r -> new Thread(r, "ClientFilteringSynchronizer"));
    private final ScheduledOperationChainRegistry<String> chainIdRegistry = new ScheduledOperationChainRegistry();
    private final ClientFilteringSharedSource clientFilteringSharedSource;
    private final Notifier notifier;
    private final ClusterLockManager clusterLockManager;

    public ClientFilteringSynchronizer(ClientFilteringService clientFilteringService, ClientFilteringSharedSource clientFilteringSharedSource, Notifier notifier, ClusterLockManager clusterLockManager) {
        this(clientFilteringService, 1000L, 5000L, clientFilteringSharedSource, notifier, clusterLockManager);
    }

    ClientFilteringSynchronizer(ClientFilteringService clientFilteringService, long rescheduleDelayMs, long rescheduleOnErrorDelayMs, ClientFilteringSharedSource clientFilteringSharedSource, Notifier notifier, ClusterLockManager clusterLockManager) {
        this.clientFilteringService = clientFilteringService;
        this.rescheduleDelayMs = rescheduleDelayMs;
        this.rescheduleOnErrorDelayMs = rescheduleOnErrorDelayMs;
        this.clientFilteringSharedSource = clientFilteringSharedSource;
        this.notifier = notifier;
        this.clusterLockManager = clusterLockManager;
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    @EventListener
    public void onClusterConnected(ConnectedToClusterEvent event) {
        String clusterName = event.getCluster();
        this.scheduleNextPoll(this.nextChainId(clusterName), clusterName, 0L);
    }

    private void scheduleNextPoll(int chainId, String clusterName, long delayMs) {
        this.executor.schedule(() -> {
            try {
                this.runPoll(chainId, clusterName);
            }
            catch (Exception e) {
                log.error("Unexpected error when polling client filtering config from the cluster {}.", (Object)clusterName, (Object)e);
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPoll(int chainId, String clusterName) {
        if (!this.chainIdRegistry.sameAsCurrentId((Object)clusterName, chainId)) {
            return;
        }
        if (this.clientFilteringService.hasLicensedFeature()) {
            LoggingReadWriteLock lockForCluster = this.clusterLockManager.getLockForCluster(clusterName);
            if (!lockForCluster.acquireWriteLock()) {
                this.scheduleNextPoll(chainId, clusterName, this.rescheduleOnErrorDelayMs);
                return;
            }
            try {
                ClusterClientFilteringDTO deployedInMC = this.clientFilteringService.getFullClientFilteringConfigForCluster(clusterName);
                ClusterClientFilteringDTO deployedInCluster = this.clientFilteringSharedSource.get(clusterName);
                if (this.differentFiltersSavedInCluster(deployedInMC, deployedInCluster)) {
                    log.info("Local client filtering configs doesn't match the one from the cluster. Updating local config...");
                    String newETag = deployedInCluster.getEtag();
                    this.clientFilteringService.deleteAll(clusterName, false);
                    for (ClientFilteringListWithEntriesDTO list : deployedInCluster.getAllClientFilteringLists()) {
                        this.clientFilteringService.create(clusterName, list.toModel(), false);
                    }
                    this.clientFilteringService.deploy(clusterName, deployedInCluster.getStatus(), deployedInCluster.getType(), newETag);
                    this.notifier.signal(Note.Matter.CLIENT_FILTERS_UPDATED_BY_ANOTHER_MC.on(clusterName, " ETag " + newETag));
                    log.info("Client filtering configuration with eTag {} applied to the local storage", (Object)newETag);
                }
            }
            catch (Exception e) {
                Throwable error = ExceptionUtil.peelClientError((Throwable)e);
                if (ExceptionUtil.isRecoverableClientError((Throwable)error)) {
                    this.scheduleNextPoll(chainId, clusterName, this.rescheduleOnErrorDelayMs);
                    return;
                }
                this.chainIdRegistry.cleanUp((Object)clusterName, chainId);
                log.error("Error when polling or deploying client filtering config for cluster {}. Stopped sending config to this cluster.", (Object)clusterName, (Object)error);
            }
            finally {
                lockForCluster.writeLock().unlock();
            }
        }
        this.scheduleNextPoll(chainId, clusterName, this.rescheduleDelayMs);
    }

    private boolean differentFiltersSavedInCluster(ClusterClientFilteringDTO deployedInMC, ClusterClientFilteringDTO deployedInCluster) {
        return deployedInCluster != null && !Objects.equals(deployedInMC.getEtag(), deployedInCluster.getEtag());
    }

    int nextChainId(String cluster) {
        return this.chainIdRegistry.nextId((Object)cluster);
    }
}

