/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.client;

import com.hazelcast.webmonitor.model.sql.client.ClientModel;
import com.hazelcast.webmonitor.repositories.sql.ClientDAO;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.TimeZone;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ClientService {
    public static final int DEFAULT_INTERVAL_MS = 60000;
    private final ClientDAO clientDAO;

    public List<ClientModel> findClients(String cluster, long time, long interval) {
        if (time == 0L) {
            time = System.currentTimeMillis();
        }
        if (interval == 0L) {
            interval = 60000L;
        }
        return this.clientDAO.findClientsInInterval(cluster, OffsetDateTime.ofInstant(Instant.ofEpochMilli(time - interval), TimeZone.getDefault().toZoneId()), OffsetDateTime.ofInstant(Instant.ofEpochMilli(time), TimeZone.getDefault().toZoneId()));
    }

    @ConstructorProperties(value={"clientDAO"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientService(ClientDAO clientDAO) {
        this.clientDAO = clientDAO;
    }
}

