/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.controller.dto.MemberDetailsDTO;
import com.hazelcast.webmonitor.controller.dto.MemberStatsWarningDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.MemberScriptResult;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.model.sql.MemberModel;
import com.hazelcast.webmonitor.networking.IPAddressUtil;
import com.hazelcast.webmonitor.repositories.sql.MemberDAO;
import com.hazelcast.webmonitor.service.CentralManager;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MemberRemovedEvent;
import com.hazelcast.webmonitor.service.MemberStatsService;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.SettingsService;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.exception.ConfigParseException;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import com.hazelcast.webmonitor.service.memberconfig.ParsedMemberConfig;
import com.hazelcast.webmonitor.service.telemetry.ConsoleExecutionListener;
import com.hazelcast.webmonitor.utils.EmptyStatement;
import com.hazelcast.webmonitor.utils.MemberUtil;
import com.hazelcast.webmonitor.utils.XmlUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MemberManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemberManager.class);
    private static final long RECOMMENDED_PROCESSORS_THRESHOLD = 8L;
    private static final int SYSTEM_PROPS_CACHE_EXPIRE_DURATION_MINUTES = 10;
    private static final int SYSTEM_PROPS_CACHE_MAX_SIZE = 1000;
    private final LoadingCache<String, Map<String, String>> systemPropsCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build(CacheLoader.from(key -> {
        String[] ss = CentralManager.extractClusterAndTime((String)key);
        String cluster = ss[0];
        String member = ss[1];
        Map props = this.doGetSystemProperties(cluster, member);
        props.replaceAll((k, v) -> v.replace("\r", "\\r").replace("\n", "\\n"));
        return props;
    }));
    private final StateManager stateManager;
    private final MCClientManager clientManager;
    private final MemberConfigService memberConfigService;
    private final OperationDispatcher dispatcher;
    private final MemberStatsService memberStatsService;
    private final SettingsService settingsService;
    private final MemberDAO memberDAO;
    private final Clock clock;
    private final MCConfigurationProperties mcProperties;
    private final List<ConsoleExecutionListener> consoleExecutionListeners;

    public String getConfig(String cluster, String member) {
        MemberConfig memberConfig = this.memberConfigService.getMemberConfig(MemberIdentifier.of((String)cluster, (String)member));
        if (memberConfig != null) {
            return this.maskConfigProperties(memberConfig.getRawXmlConfig());
        }
        return null;
    }

    public Map<String, ParsedMemberConfig> getAllMemberConfigs(String clusterName) {
        return this.getMemberList(clusterName).stream().map(memberAddr -> BiTuple.of((Object)memberAddr, (Object)this.memberConfigService.getMemberConfig(MemberIdentifier.of((String)clusterName, (String)memberAddr)))).filter(pair -> pair.element2 != null).map(pair -> BiTuple.of((Object)((String)pair.element1), (Object)MemberManager.safelyParse((MemberConfig)((MemberConfig)pair.element2)))).filter(pair -> pair.element2 != null).collect(Collectors.toMap(BiTuple::element1, BiTuple::element2));
    }

    private static ParsedMemberConfig safelyParse(MemberConfig config) {
        try {
            return config.parse();
        }
        catch (ConfigParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ParsedMemberConfig getParsedConfig(String cluster, String member) {
        MemberConfig memberConfig = this.memberConfigService.getMemberConfig(MemberIdentifier.of((String)cluster, (String)member));
        if (memberConfig != null) {
            return memberConfig.parse();
        }
        return null;
    }

    public void reloadConfigCache(String cluster) {
        this.memberConfigService.reloadConfigs(cluster);
    }

    public Map<String, String> getSystemProperties(String cluster, String memberAddress) {
        try {
            Map result = (Map)this.systemPropsCache.get((Object)(cluster + "_" + memberAddress));
            return this.filterHiddenProperties(result);
        }
        catch (Exception ignore) {
            EmptyStatement.ignore((Throwable)ignore);
            return Collections.emptyMap();
        }
    }

    private Map<String, String> doGetSystemProperties(String cluster, String memberAddress) {
        return (Map)this.executeOnMember(cluster, memberAddress, MCClient::getSystemProperties, e -> String.format("Failed to get system properties of member %s from cluster %s: %s", memberAddress, cluster, e.getMessage()));
    }

    public void runGc(String cluster, String memberAddress) {
        this.executeOnMember(cluster, memberAddress, MCClient::runGc, e -> String.format("Failed to run garbage collection on member %s from cluster %s: %s", memberAddress, cluster, e.getMessage()));
    }

    public String getThreadDump(String cluster, String memberAddress, boolean dumpDeadLocks) {
        return (String)this.executeOnMember(cluster, memberAddress, (mcClient, member) -> mcClient.getThreadDump(member, dumpDeadLocks), e -> String.format("Failed to get dump of %s threads of member %s from cluster %s: %s", dumpDeadLocks ? "dead-locked" : "all", memberAddress, cluster, e.getMessage()));
    }

    public void shutdown(String cluster, String memberAddress) {
        this.executeOnMember(cluster, memberAddress, (mcClient, member) -> {
            mcClient.shutdownMember(member);
            return CompletableFuture.completedFuture(null);
        }, e -> String.format("Failed to shut down member %s from cluster %s: %s", memberAddress, cluster, e.getMessage()));
    }

    public void promoteLiteMember(String cluster, String memberAddress) {
        this.executeOnMember(cluster, memberAddress, MCClient::promoteLiteMember, e -> String.format("Failed to promote member %s from cluster %s: %s", memberAddress, cluster, e.getMessage()));
    }

    public Collection<MemberScriptResult> runScript(String cluster, Set<String> memberAddresses, String engine, String script) {
        return this.dispatcher.executeOnMemberAddresses(cluster, memberAddresses, (mcClient, member) -> mcClient.runScript(member, engine, script).thenApply(output -> MemberScriptResult.success((String)MemberUtil.getMemberAddress((Member)member), (String)output)), (member, throwable) -> MemberScriptResult.failure((String)MemberUtil.getMemberAddress((Member)member), (Throwable)throwable));
    }

    public String runConsoleCommand(String cluster, String memberAddress, String namespace, String command) {
        String result = (String)this.executeOnMember(cluster, memberAddress, (mcClient, member) -> mcClient.runConsoleCommand(member, namespace, command), e -> {
            this.consoleExecutionListeners.forEach(ConsoleExecutionListener::consoleExecutionFailed);
            return String.format("Failed to execute console command on member %s from cluster %s: %s", memberAddress, cluster, e.getMessage());
        });
        this.consoleExecutionListeners.forEach(ConsoleExecutionListener::consoleExecutionSucceeded);
        return result;
    }

    private <T> T executeOnMember(String cluster, String memberAddress, BiFunction<MCClient, Member, CompletableFuture<T>> operation, Function<Exception, String> errorMessageConstructor) {
        return (T)this.dispatcher.executeOnMember(MemberIdentifier.of((String)cluster, (String)memberAddress), operation, errorMessageConstructor);
    }

    public List<MemberDetailsDTO> getMembers(String cluster, long time) {
        return this.getMembers(cluster, time, 0L);
    }

    public List<MemberDetailsDTO> getMembers(String cluster, long time, long interval) {
        long time0 = time > 0L ? time : this.clock.currentTimeMillis();
        Optional<AllState> state = Optional.ofNullable(this.stateManager.getLatestState(cluster));
        Map membersCountByAddress = state.map(arg_0 -> this.getMembersCountByAddress(arg_0)).orElse(Collections.emptyMap());
        ArrayList<MemberDetailsDTO> result = new ArrayList<MemberDetailsDTO>();
        List knownMembers = interval == 0L ? this.getHistoricalMemberList(cluster, time0) : this.memberDAO.findMembersInInterval(cluster, MemberManager.asOffsetDateTime((long)(time0 - interval)), MemberManager.asOffsetDateTime((long)time0));
        for (MemberModel memberModel : knownMembers) {
            Optional<TimedMemberState> timedMemberState = state.map(s -> (TimedMemberState)s.getTimedMemberStates().get(memberModel.getAddress()));
            Optional<MemberState> memberState = timedMemberState.map(TimedMemberState::getMemberState);
            long firstSeenAt = memberModel.getFirstSeenAt().toInstant().toEpochMilli();
            Long lastSeenAt = memberModel.getLastSeenAt() != null ? Long.valueOf(memberModel.getLastSeenAt().toInstant().toEpochMilli()) : null;
            MemberIdentifier memberIdentifier = MemberIdentifier.of((String)memberModel.getCluster(), (String)memberModel.getAddress());
            boolean jetEnabled = Optional.ofNullable((MemberConfig)this.memberConfigService.asMap().get(memberIdentifier)).map(MemberConfig::parse).map(ParsedMemberConfig::isJetEnabled).orElse(true);
            MemberDetailsDTO memberDetailsDto = MemberDetailsDTO.builder().address(memberModel.getAddress()).uuid((String)memberState.map(MemberState::getUuid).orElse(null)).cpMemberUuid((String)memberState.map(MemberState::getCpMemberUuid).orElse(null)).slowOperations(memberState.map(ms -> !ms.getOperationStats().getSlowOperations().isEmpty()).orElse(false).booleanValue()).ownedPartitions(memberState.map(ms -> ms.getMemberPartitionState().getPartitions().size()).orElse(0).intValue()).version((String)memberState.map(ms -> ms.getNodeState().getMemberVersion().toString()).orElse(null)).jetEnabled(jetEnabled).warnings(memberState.map(ms -> this.getWarnings(cluster, ms, membersCountByAddress, time0)).orElse(Collections.emptyList())).scriptingEnabled(timedMemberState.map(TimedMemberState::isScriptingEnabled).orElse(false).booleanValue()).consoleEnabled(timedMemberState.map(TimedMemberState::getConsoleEnabled).orElse(false).booleanValue()).mcDataAccessEnabled(timedMemberState.map(TimedMemberState::getMcDataAccessEnabled).orElse(true).booleanValue()).lite(timedMemberState.map(TimedMemberState::isLite).orElse(false).booleanValue()).firstSeenAt(firstSeenAt).lastSeenAt(lastSeenAt).build();
            result.add(memberDetailsDto);
        }
        return result;
    }

    public List<String> getMemberList(String cluster) {
        return this.getMemberList(cluster, this.clock.currentTimeMillis());
    }

    public List<String> getMemberList(String cluster, long time) {
        return this.getHistoricalMemberList(cluster, time).stream().map(MemberModel::getAddress).collect(Collectors.toList());
    }

    private static OffsetDateTime asOffsetDateTime(long instantInMillis) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(instantInMillis), TimeZone.getDefault().toZoneId());
    }

    private List<MemberModel> getHistoricalMemberList(String cluster, long time) {
        return this.memberDAO.findAllByClusterAndTime(cluster, MemberManager.asOffsetDateTime((long)time));
    }

    @EventListener
    public void onMemberJoined(MembersJoinedEvent event) {
        String cluster = event.getCluster();
        Set members = event.getMembers();
        for (Member member : members) {
            try {
                MemberModel model = new MemberModel();
                model.setCluster(cluster);
                model.setAddress(MemberUtil.getMemberAddress((Member)member));
                model.setFirstSeenAt(this.clock.currentOffsetDateTime());
                this.memberDAO.insertOrUpdate(model);
            }
            catch (Exception e) {
                log.error("Could not persist member {} data.", (Object)member, (Object)e);
            }
        }
        try {
            MCClient client = this.clientManager.clientFor(cluster);
            Set reachableMembers = client.getHzClient().getCluster().getMembers().stream().map(MemberUtil::getMemberAddress).collect(Collectors.toSet());
            List unreachableMembers = this.memberDAO.findAllByCluster(cluster).stream().map(MemberModel::getAddress).filter(address -> !reachableMembers.contains(address)).collect(Collectors.toList());
            this.memberDAO.updateLastSeenAt(cluster, unreachableMembers, this.clock.currentOffsetDateTime());
        }
        catch (Exception e) {
            log.error("Could not persist unreachable members for cluster {}.", (Object)cluster, (Object)e);
        }
    }

    @EventListener
    public void onMemberLeft(MemberRemovedEvent event) {
        Member member = event.getMember();
        try {
            this.memberDAO.updateLastSeenAt(event.getCluster(), MemberUtil.getMemberAddress((Member)member), this.clock.currentOffsetDateTime());
        }
        catch (Exception e) {
            log.error("Could not persist member {} data.", (Object)member, (Object)e);
        }
    }

    private List<MemberStatsWarningDTO> getWarnings(String cluster, MemberState memberState, Map<String, Long> membersCountByAddress, long time) {
        ArrayList<MemberStatsWarningDTO> warnings = new ArrayList<MemberStatsWarningDTO>();
        if (this.isSameMachineAsOtherMember(membersCountByAddress, memberState)) {
            warnings.add(new MemberStatsWarningDTO("sameMachineAsOtherMembers"));
        }
        if (this.isProcessorsBelowThreshold(cluster, memberState.getAddress(), time)) {
            warnings.add(new MemberStatsWarningDTO("availableProcessorsBelowRecommendation", Collections.singletonMap("processors", Long.toString(8L))));
        }
        return warnings;
    }

    private boolean isSameMachineAsOtherMember(Map<String, Long> membersCountByAddress, MemberState memberState) {
        String address = memberState.getAddress();
        Long memberCount = membersCountByAddress.get(IPAddressUtil.trimPort((String)address));
        if (memberCount == null) {
            return false;
        }
        return this.warningsEnabled() && memberCount > 1L;
    }

    private boolean isProcessorsBelowThreshold(String cluster, String memberAddress, long time) {
        if (!this.warningsEnabled()) {
            return false;
        }
        long availableProcessors = this.memberStatsService.getAvailableProcessors(cluster, memberAddress, time);
        return availableProcessors < 8L;
    }

    boolean warningsEnabled() {
        return this.mcProperties.getInternal().isMemberWarningsEnabled();
    }

    private Map<String, Long> getMembersCountByAddress(AllState state) {
        return state.getTimedMemberStates().stream().collect(Collectors.groupingBy(memberState -> IPAddressUtil.trimPort((String)memberState.getMemberState().getAddress()), Collectors.counting()));
    }

    private Map<String, String> filterHiddenProperties(Map<String, String> propertiesMap) {
        List hiddenProperties = this.settingsService.getHiddenProperties();
        hiddenProperties.forEach(propertiesMap::remove);
        return propertiesMap;
    }

    private String maskConfigProperties(String rawXmlConfig) {
        List xpathExpressions = this.settingsService.getMaskedConfigProperties();
        return XmlUtil.maskXPathExpressionsInXml((String)rawXmlConfig, (String)"****", (List)xpathExpressions);
    }

    @ConstructorProperties(value={"stateManager", "clientManager", "memberConfigService", "dispatcher", "memberStatsService", "settingsService", "memberDAO", "clock", "mcProperties", "consoleExecutionListeners"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MemberManager(StateManager stateManager, MCClientManager clientManager, MemberConfigService memberConfigService, OperationDispatcher dispatcher, MemberStatsService memberStatsService, SettingsService settingsService, MemberDAO memberDAO, Clock clock, MCConfigurationProperties mcProperties, List<ConsoleExecutionListener> consoleExecutionListeners) {
        this.stateManager = stateManager;
        this.clientManager = clientManager;
        this.memberConfigService = memberConfigService;
        this.dispatcher = dispatcher;
        this.memberStatsService = memberStatsService;
        this.settingsService = settingsService;
        this.memberDAO = memberDAO;
        this.clock = clock;
        this.mcProperties = mcProperties;
        this.consoleExecutionListeners = consoleExecutionListeners;
    }
}

