/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Tags;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.MapIndexRegistry;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.metrics.DataPointsReceivedEvent;
import java.util.SortedSet;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class MapIndexStatsManager {
    static final String MAP_INDEX_METRIC = "map.index.creationTime";
    private static final int REGISTRY_MAX_SIZE = 10000;
    private static final int REGISTRY_TTL_MIN = 10;
    private final MapIndexRegistry mapIndexRegistry;

    public MapIndexStatsManager(Clock clock) {
        this.mapIndexRegistry = new MapIndexRegistry(clock, 10000, 10);
    }

    @EventListener
    public void dataPointsReceived(DataPointsReceivedEvent event) {
        MemberIdentifier memberIdent = event.getMemberIdent();
        event.getDataPoints().stream().filter(dataPoint -> MAP_INDEX_METRIC.equals(dataPoint.getName())).map(MetricDataPoint::getTags).forEach(tags -> {
            String clientName = tags.getTag("clientname").map(Tags.Tag::getValue).orElse(null);
            String mapName = tags.getTag("name").map(Tags.Tag::getValue).orElse(null);
            String indexName = tags.getTag("index").map(Tags.Tag::getValue).orElse(null);
            if (mapName != null) {
                this.mapIndexRegistry.register(memberIdent.getClusterName(), clientName, mapName, indexName);
            }
        });
    }

    public SortedSet<String> getMapIndexesByMap(String cluster, String mapName) {
        return this.mapIndexRegistry.getIndexesByMap(cluster, mapName);
    }
}

