/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.webmonitor.config.properties.MCClientConfigurationProperties;
import com.hazelcast.webmonitor.controller.exception.ClientFailedToStartApiException;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.exception.NoClientForClusterException;
import com.hazelcast.webmonitor.service.serialization.ClientSerializerFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.EventListener;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MCClientManager
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MCClientManager.class);
    public static final String MC_CLIENT_PREFIX = "MC-Client-";
    private static final long MC_CLIENT_CLUSTER_CONNECT_TIMEOUT_MILLIS = Long.MAX_VALUE;
    private static final int MC_CLIENT_FUTURE_RESOLVE_TIMEOUT = 10;
    private static final int MAX_CLIENT_INSTANTIATION_RETRIES = 10;
    private final ConcurrentMap<String, CompletableFuture<MCClient>> clients = new ConcurrentHashMap();
    private Function<ClientConfig, HazelcastInstance> clientFactory = HazelcastClient::newHazelcastClient;
    private final ReadWriteLock closeInProgressLock = new ReentrantReadWriteLock();
    private boolean closed;
    private final Set<String> connectedClusters = ConcurrentHashMap.newKeySet();
    private final ApplicationEventPublisher publisher;
    private final MCClientConfigurationProperties properties;

    @Override
    public void close() {
        this.closeInProgressLock.writeLock().lock();
        try {
            this.clients.forEach((cluster, clientFuture) -> {
                MCClient mcClient = this.resolveClientFuture(cluster, clientFuture);
                mcClient.shutdown();
            });
            this.closed = true;
        }
        finally {
            this.closeInProgressLock.writeLock().unlock();
        }
    }

    public Set<String> getConnectedClusters() {
        return this.connectedClusters;
    }

    public MCClient connect(ClientConfig clientConfig) {
        String cluster = clientConfig.getClusterName();
        this.closeInProgressLock.readLock().lock();
        try {
            if (this.closed) {
                throw new RuntimeException("MCClientManager has closed!");
            }
            this.appropriateClientConfig(clientConfig, cluster);
            CompletableFuture<MCClient> clientFuture = new CompletableFuture<MCClient>();
            this.clients.put(cluster, clientFuture);
            log.debug("Starting a new MC Client for cluster {}.", (Object)cluster);
            int counter = 0;
            HazelcastClientInstanceImpl imdgClient = null;
            do {
                try {
                    imdgClient = MCClientManager.toImpl((HazelcastInstance)((HazelcastInstance)this.clientFactory.apply(clientConfig)));
                }
                catch (InvalidConfigurationException e) {
                    if (counter == 10) {
                        throw e;
                    }
                    clientConfig.setInstanceName("MC-Client-" + counter++ + "-" + cluster);
                }
            } while (imdgClient == null);
            MCClient mcClient = new MCClient(imdgClient);
            log.debug("Started a new MC Client for cluster {}.", (Object)cluster);
            clientFuture.complete(mcClient);
            MCClient mCClient = mcClient;
            return mCClient;
        }
        catch (Exception e) {
            log.warn("Couldn't start a new MC client for cluster {}", (Object)cluster, (Object)e);
            throw new ClientFailedToStartApiException((Throwable)e);
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    private void appropriateClientConfig(ClientConfig clientConfig, String clusterName) {
        clientConfig.setProperty("hazelcast.client.internal.mc.mode", "true").setProperty(ClientProperty.METRICS_ENABLED.getName(), "false").setProperty(ClusterProperty.LOGGING_TYPE.getName(), "slf4j").setInstanceName("MC-Client-" + clusterName);
        clientConfig.getNetworkConfig().setSmartRouting(true);
        SerializationConfig serializationConfig = clientConfig.getSerializationConfig();
        serializationConfig.addDataSerializableFactory(1, (DataSerializableFactory)new ClientSerializerFactory());
        clientConfig.getConnectionStrategyConfig().setAsyncStart(true);
        ConnectionRetryConfig retryConfig = clientConfig.getConnectionStrategyConfig().getConnectionRetryConfig();
        retryConfig.setInitialBackoffMillis(this.properties.getInitialBackoffMillis()).setMultiplier((double)this.properties.getBackoffMultiplier()).setMaxBackoffMillis(this.properties.getMaxBackoffMillis());
        if (retryConfig.getClusterConnectTimeoutMillis() < 0L) {
            retryConfig.setClusterConnectTimeoutMillis(Long.MAX_VALUE);
        }
        clientConfig.addListenerConfig(new ListenerConfig((EventListener)new ClientLifecycleListener(this, clusterName, null)));
        clientConfig.addListenerConfig(new ListenerConfig((EventListener)new MembershipListener(this, clusterName, null)));
    }

    public void disconnect(String cluster) {
        CompletableFuture clientFuture = (CompletableFuture)this.clients.get(cluster);
        if (clientFuture == null) {
            return;
        }
        MCClient mcClient = this.resolveClientFuture(cluster, clientFuture);
        if (mcClient != null) {
            mcClient.shutdown();
        }
    }

    private MCClient resolveClientFuture(String cluster, CompletableFuture<MCClient> clientFuture) {
        try {
            return clientFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new NoClientForClusterException(cluster, (Throwable)e);
        }
    }

    @Nonnull
    public MCClient clientFor(String cluster) {
        MCClient client = this.resolveClientFuture(cluster, (CompletableFuture)this.clients.get(cluster));
        if (client == null) {
            throw new NoClientForClusterException(cluster);
        }
        return client;
    }

    public void setClientFactory(Function<ClientConfig, HazelcastInstance> clientFactory) {
        this.clientFactory = clientFactory;
    }

    private static HazelcastClientInstanceImpl toImpl(HazelcastInstance instance) {
        if (instance instanceof HazelcastClientInstanceImpl) {
            return (HazelcastClientInstanceImpl)instance;
        }
        return ((HazelcastClientProxy)instance).client;
    }

    @ConstructorProperties(value={"publisher", "properties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MCClientManager(ApplicationEventPublisher publisher, MCClientConfigurationProperties properties) {
        this.publisher = publisher;
        this.properties = properties;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }

    static /* synthetic */ Set access$300(MCClientManager x0) {
        return x0.connectedClusters;
    }

    static /* synthetic */ ConcurrentMap access$400(MCClientManager x0) {
        return x0.clients;
    }

    static /* synthetic */ ApplicationEventPublisher access$500(MCClientManager x0) {
        return x0.publisher;
    }
}

