/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Tags;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.DeviceRegistry;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.metrics.DataPointsReceivedEvent;
import java.util.SortedSet;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class DeviceStatsManager {
    private static final int REGISTRY_MAX_SIZE = 10000;
    private static final int REGISTRY_TTL_MIN = 10;
    private final DeviceRegistry deviceRegistry;

    public DeviceStatsManager(Clock clock) {
        this.deviceRegistry = new DeviceRegistry(clock, 10000, 10);
    }

    @EventListener
    public void dataPointsReceived(DataPointsReceivedEvent event) {
        MemberIdentifier memberIdent = event.getMemberIdent();
        event.getDataPoints().stream().filter(dataPoint -> "tstore.device.maxSpace".equals(dataPoint.getName())).map(MetricDataPoint::getTags).forEach(tags -> {
            String deviceName = tags.getTag("name").map(Tags.Tag::getValue).orElse(null);
            if (deviceName != null) {
                this.deviceRegistry.register(memberIdent.getClusterName(), memberIdent.getMemberAddress(), deviceName);
            }
        });
    }

    public SortedSet<String> getDeviceNamesByMember(String cluster, String memberAddress) {
        return this.deviceRegistry.getDeviceNamesByMember(cluster, memberAddress);
    }
}

