/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.dto.CacheThroughputStatsDTO;
import com.hazelcast.webmonitor.controller.dto.ExecutorThroughputStatsDTO;
import com.hazelcast.webmonitor.controller.dto.MapThroughputStatsDTO;
import com.hazelcast.webmonitor.controller.dto.OperationThroughputStatsDTO;
import com.hazelcast.webmonitor.controller.dto.QueueThroughputStatsDTO;
import com.hazelcast.webmonitor.controller.dto.TopicThroughputStatsDTO;
import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.imdg.CacheMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.CommonMapMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.ExecutorMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.MapMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.MultiMapMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.QueueMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.ReplicatedMapMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.TopicMetricsQueryFactory;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.CounterAggregates;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.OperationPerformanceAggregates;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.DataStructureStatsService;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.exception.DataPointSeriesMismatchException;
import com.hazelcast.webmonitor.service.metrics.MetricsService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class DataStructureStatsService {
    private static final long MS_IN_SEC = 1000L;
    private static final long SINCE_BEGINNING_LOOKUP_INTERVAL_MS = 30000L;
    private final MetricsService metricsService;
    private final StateManager stateManager;
    private final MemberManager memberManager;
    private final Clock clock;

    public DataStructureStatsService(MetricsService metricsService, StateManager stateManager, MemberManager memberManager, Clock clock) {
        this.metricsService = metricsService;
        this.stateManager = stateManager;
        this.memberManager = memberManager;
        this.clock = clock;
    }

    public List<MapThroughputStatsDTO> getMapThroughputStats(String cluster, String mapName, long time, long interval) {
        return this.getThroughputStats(cluster, time, interval, (memberAddress, start, end) -> (MapMetricsQueryFactory)new MapMetricsQueryFactory.Builder().cluster(cluster).member(memberAddress).name(mapName).start(start).end(end).build(), (arg_0, arg_1, arg_2) -> this.getMapThroughputSinceBeginning(arg_0, arg_1, arg_2), (queryFactory, memberAddress, t) -> this.getMapThroughputWithinRange(queryFactory, memberAddress), false);
    }

    private MapThroughputStatsDTO getMapThroughputSinceBeginning(MapMetricsQueryFactory queryFactory, String address, long time) {
        Optional<Long> creationTimeResult = this.metricsService.queryLatestRaw(queryFactory.creationTimeQuery()).map(DataPointAware::getValue);
        if (!creationTimeResult.isPresent()) {
            return null;
        }
        long creationTime = creationTimeResult.get();
        long intervalInSeconds = (time - creationTime) / 1000L;
        return this.buildMapThroughputStats(address, this.getPerformanceAggregateSinceBeginning(queryFactory.getCountQuery(), queryFactory.totalGetLatencyQuery(), queryFactory.totalMaxGetLatencyQuery(), intervalInSeconds), this.getPerformanceAggregateSinceBeginning(queryFactory.putCountQuery(), queryFactory.totalPutLatencyQuery(), queryFactory.totalMaxPutLatencyQuery(), intervalInSeconds), this.getPerformanceAggregateSinceBeginning(queryFactory.removeCountQuery(), queryFactory.totalRemoveLatencyQuery(), queryFactory.totalMaxRemoveLatencyQuery(), intervalInSeconds), this.getPerformanceAggregateSinceBeginning(queryFactory.setCountQuery(), queryFactory.totalSetLatencyQuery(), queryFactory.totalMaxSetLatencyQuery(), intervalInSeconds));
    }

    private MapThroughputStatsDTO getMapThroughputWithinRange(MapMetricsQueryFactory queryFactory, String address) {
        return this.buildMapThroughputStats(address, this.getPerformanceAggregate(queryFactory.getCountQuery(), queryFactory.totalGetLatencyQuery()), this.getPerformanceAggregate(queryFactory.putCountQuery(), queryFactory.totalPutLatencyQuery()), this.getPerformanceAggregate(queryFactory.removeCountQuery(), queryFactory.totalRemoveLatencyQuery()), this.getPerformanceAggregate(queryFactory.setCountQuery(), queryFactory.totalSetLatencyQuery()));
    }

    private MapThroughputStatsDTO buildMapThroughputStats(String address, OperationPerformanceAggregates getPerfAggregates, OperationPerformanceAggregates putPerfAggregates, OperationPerformanceAggregates removePerfAggregates, OperationPerformanceAggregates setPerfAggregates) {
        return MapThroughputStatsDTO.builder().memberAddress(address).getThroughput(getPerfAggregates.throughputPerSecond()).getAvgLatency(getPerfAggregates.avgLatency()).getHighestAvgLatency(getPerfAggregates.highestAvgLatency()).putThroughput(putPerfAggregates.throughputPerSecond()).putAvgLatency(putPerfAggregates.avgLatency()).putHighestAvgLatency(putPerfAggregates.highestAvgLatency()).removeThroughput(removePerfAggregates.throughputPerSecond()).removeAvgLatency(removePerfAggregates.avgLatency()).removeHighestAvgLatency(removePerfAggregates.highestAvgLatency()).setThroughput(setPerfAggregates.throughputPerSecond()).setAvgLatency(setPerfAggregates.avgLatency()).setHighestAvgLatency(setPerfAggregates.highestAvgLatency()).build();
    }

    public List<OperationThroughputStatsDTO> getMultiMapThroughputStats(String cluster, String mapName, long time, long interval) {
        return this.getThroughputStats(cluster, time, interval, (memberAddress, start, end) -> (MultiMapMetricsQueryFactory)new MultiMapMetricsQueryFactory.Builder().cluster(cluster).member(memberAddress).name(mapName).start(start).end(end).build(), (arg_0, arg_1, arg_2) -> this.getCommonMapThroughputSinceBeginning(arg_0, arg_1, arg_2), (queryFactory, memberAddress, t) -> this.getMultiMapThroughputWithinRange(queryFactory, memberAddress), false);
    }

    private OperationThroughputStatsDTO getMultiMapThroughputWithinRange(MultiMapMetricsQueryFactory queryFactory, String address) {
        return this.buildOperationThroughputStats(address, this.getPerformanceAggregate(queryFactory.getCountQuery(), queryFactory.totalGetLatencyQuery()), this.getPerformanceAggregate(queryFactory.putCountQuery(), queryFactory.totalPutLatencyQuery()), this.getPerformanceAggregate(queryFactory.removeCountQuery(), queryFactory.totalRemoveLatencyQuery()));
    }

    public List<OperationThroughputStatsDTO> getReplicatedMapThroughputStats(String cluster, String mapName, long time, long interval) {
        return this.getThroughputStats(cluster, time, interval, (memberAddress, start, end) -> (ReplicatedMapMetricsQueryFactory)new ReplicatedMapMetricsQueryFactory.Builder().cluster(cluster).member(memberAddress).name(mapName).start(start).end(end).build(), (arg_0, arg_1, arg_2) -> this.getCommonMapThroughputSinceBeginning(arg_0, arg_1, arg_2), (queryFactory, memberAddress, t) -> this.getReplicatedMapThroughputWithinRange(queryFactory, memberAddress), false);
    }

    private <F extends CommonMapMetricsQueryFactory<F>> OperationThroughputStatsDTO getCommonMapThroughputSinceBeginning(CommonMapMetricsQueryFactory<F> queryFactory, String address, long time) {
        Optional<Long> creationTimeResult = this.metricsService.queryLatestRaw(queryFactory.creationTimeQuery()).map(DataPointAware::getValue);
        if (!creationTimeResult.isPresent()) {
            return null;
        }
        long creationTime = creationTimeResult.get();
        long intervalInSeconds = (time - creationTime) / 1000L;
        return this.buildOperationThroughputStats(address, this.getPerformanceAggregateSinceBeginning(queryFactory.getCountQuery(), queryFactory.totalGetLatencyQuery(), queryFactory.totalMaxGetLatencyQuery(), intervalInSeconds), this.getPerformanceAggregateSinceBeginning(queryFactory.putCountQuery(), queryFactory.totalPutLatencyQuery(), queryFactory.totalMaxPutLatencyQuery(), intervalInSeconds), this.getPerformanceAggregateSinceBeginning(queryFactory.removeCountQuery(), queryFactory.totalRemoveLatencyQuery(), queryFactory.totalMaxRemoveLatencyQuery(), intervalInSeconds));
    }

    private OperationThroughputStatsDTO getReplicatedMapThroughputWithinRange(ReplicatedMapMetricsQueryFactory queryFactory, String address) {
        return this.buildOperationThroughputStats(address, this.getPerformanceAggregate(queryFactory.getCountQuery(), queryFactory.totalGetLatencyQuery()), this.getPerformanceAggregate(queryFactory.putCountQuery(), queryFactory.totalPutLatencyQuery()), this.getPerformanceAggregate(queryFactory.removeCountQuery(), queryFactory.totalRemoveLatencyQuery()));
    }

    private OperationThroughputStatsDTO buildOperationThroughputStats(String address, OperationPerformanceAggregates getPerfAggregates, OperationPerformanceAggregates putPerfAggregates, OperationPerformanceAggregates removePerfAggregates) {
        return OperationThroughputStatsDTO.builder().memberAddress(address).getThroughput(getPerfAggregates.throughputPerSecond()).getAvgLatency(getPerfAggregates.avgLatency()).getHighestAvgLatency(getPerfAggregates.highestAvgLatency()).putThroughput(putPerfAggregates.throughputPerSecond()).putAvgLatency(putPerfAggregates.avgLatency()).putHighestAvgLatency(putPerfAggregates.highestAvgLatency()).removeThroughput(removePerfAggregates.throughputPerSecond()).removeAvgLatency(removePerfAggregates.avgLatency()).removeHighestAvgLatency(removePerfAggregates.highestAvgLatency()).build();
    }

    public List<CacheThroughputStatsDTO> getCacheThroughputStats(String cluster, String cacheName, long time, long interval) {
        return this.getThroughputStats(cluster, time, interval, (memberAddress, start, end) -> new CacheMetricsQueryFactory.Builder().cluster(cluster).member(memberAddress).name(cacheName).start(start).end(end).build(), (arg_0, arg_1, arg_2) -> this.getCacheThroughputSinceBeginning(arg_0, arg_1, arg_2), (queryFactory, memberAddress, t) -> this.getCacheThroughputWithinRange(queryFactory, memberAddress), false);
    }

    private CacheThroughputStatsDTO getCacheThroughputSinceBeginning(CacheMetricsQueryFactory queryFactory, String address, long time) {
        Optional<Long> creationTimeResult = this.metricsService.queryLatestRaw(queryFactory.creationTimeQuery()).map(DataPointAware::getValue);
        if (!creationTimeResult.isPresent()) {
            return null;
        }
        long creationTime = creationTimeResult.get();
        long intervalInSeconds = (time - creationTime) / 1000L;
        return new CacheThroughputStatsDTO(address, this.throughputSinceTheBeginning(queryFactory.getCountQuery(), intervalInSeconds), this.throughputSinceTheBeginning(queryFactory.putCountQuery(), intervalInSeconds), this.throughputSinceTheBeginning(queryFactory.removeCountQuery(), intervalInSeconds));
    }

    private CacheThroughputStatsDTO getCacheThroughputWithinRange(CacheMetricsQueryFactory queryFactory, String address) {
        double getThroughput = this.metricsService.computeCounterAggregates(queryFactory.getCountQuery()).getThroughputPerSecond();
        double putThroughput = this.metricsService.computeCounterAggregates(queryFactory.putCountQuery()).getThroughputPerSecond();
        double removeThroughput = this.metricsService.computeCounterAggregates(queryFactory.removeCountQuery()).getThroughputPerSecond();
        return new CacheThroughputStatsDTO(address, getThroughput, putThroughput, removeThroughput);
    }

    public List<QueueThroughputStatsDTO> getQueueThroughputStats(String cluster, String queueName, long time, long interval) {
        return this.getThroughputStats(cluster, time, interval, (memberAddress, start, end) -> new QueueMetricsQueryFactory.Builder().cluster(cluster).member(memberAddress).name(queueName).start(start).end(end).build(), (arg_0, arg_1, arg_2) -> this.getQueueThroughputSinceBeginning(arg_0, arg_1, arg_2), (queryFactory, memberAddress, t) -> new QueueThroughputStatsDTO(memberAddress, this.metricsService.computeCounterAggregates(queryFactory.numberOfOffersQuery()).getThroughputPerSecond(), this.metricsService.computeCounterAggregates(queryFactory.numberOfRejectedOffersQuery()).getThroughputPerSecond(), this.metricsService.computeCounterAggregates(queryFactory.numberOfPollsQuery()).getThroughputPerSecond(), this.metricsService.computeCounterAggregates(queryFactory.numberOfEmptyPollsQuery()).getThroughputPerSecond(), this.metricsService.computeCounterAggregates(queryFactory.numberOfOtherOperationsQuery()).getThroughputPerSecond(), this.metricsService.computeCounterAggregates(queryFactory.numberOfEventsQuery()).getThroughputPerSecond()), false);
    }

    private QueueThroughputStatsDTO getQueueThroughputSinceBeginning(QueueMetricsQueryFactory queryFactory, String address, long time) {
        return this.metricsService.queryLatestRaw(queryFactory.creationTimeQuery()).map(dataPoint -> {
            long creationTime = dataPoint.getValue();
            long intervalInSeconds = (time - creationTime) / 1000L;
            return new QueueThroughputStatsDTO(address, this.throughputSinceTheBeginning(queryFactory.numberOfOffersQuery(), intervalInSeconds), this.throughputSinceTheBeginning(queryFactory.numberOfRejectedOffersQuery(), intervalInSeconds), this.throughputSinceTheBeginning(queryFactory.numberOfPollsQuery(), intervalInSeconds), this.throughputSinceTheBeginning(queryFactory.numberOfEmptyPollsQuery(), intervalInSeconds), this.throughputSinceTheBeginning(queryFactory.numberOfOtherOperationsQuery(), intervalInSeconds), this.throughputSinceTheBeginning(queryFactory.numberOfEventsQuery(), intervalInSeconds));
        }).orElse(null);
    }

    public List<TopicThroughputStatsDTO> getTopicThroughputStats(String cluster, String topicName, long time, long interval, InstanceType topicType) {
        return this.getThroughputStats(cluster, time, interval, (memberAddress, start, end) -> new TopicMetricsQueryFactory.Builder().cluster(cluster).member(memberAddress).name(topicName).instanceType(topicType).start(start).end(end).build(), (arg_0, arg_1, arg_2) -> this.getTopicThroughputSinceBeginning(arg_0, arg_1, arg_2), (queryFactory, memberAddress, t) -> this.getTopicThroughputWithinRange(queryFactory, memberAddress), false);
    }

    private TopicThroughputStatsDTO getTopicThroughputSinceBeginning(TopicMetricsQueryFactory queryFactory, String address, long time) {
        return this.metricsService.queryLatestRaw(queryFactory.creationTimeQuery()).map(dataPoint -> {
            long creationTime = dataPoint.getValue();
            long intervalInSeconds = (time - creationTime) / 1000L;
            return new TopicThroughputStatsDTO(address, this.throughputSinceTheBeginning(queryFactory.totalPublishesQuery(), intervalInSeconds), this.throughputSinceTheBeginning(queryFactory.totalReceivedMessagesQuery(), intervalInSeconds));
        }).orElse(null);
    }

    private TopicThroughputStatsDTO getTopicThroughputWithinRange(TopicMetricsQueryFactory queryFactory, String address) {
        return new TopicThroughputStatsDTO(address, this.metricsService.computeCounterAggregates(queryFactory.totalPublishesQuery()).getThroughputPerSecond(), this.metricsService.computeCounterAggregates(queryFactory.totalReceivedMessagesQuery()).getThroughputPerSecond());
    }

    public List<ExecutorThroughputStatsDTO> getExecutorThroughputStats(String cluster, String executorName, long time, long interval) {
        return this.getThroughputStats(cluster, time, interval, (memberAddress, start, end) -> new ExecutorMetricsQueryFactory.Builder().cluster(cluster).member(memberAddress).name(executorName).start(start).end(end).build(), (arg_0, arg_1, arg_2) -> this.executorStatsSinceBeginning(arg_0, arg_1, arg_2), (queryFactory, memberAddress, t) -> this.executorStats(queryFactory, memberAddress), true);
    }

    private ExecutorThroughputStatsDTO executorStatsSinceBeginning(ExecutorMetricsQueryFactory queryFactory, String address, long time) {
        return this.metricsService.queryLatestRaw(queryFactory.creationTimeQuery()).map(dataPoint -> {
            long creationTime = dataPoint.getValue();
            long intervalInSeconds = (time - creationTime) / 1000L;
            long totalStartedTasks = this.latestMetricValue(queryFactory.startedTaskQuery());
            long totalStartLatency = this.latestMetricValue(queryFactory.totalStartLatencyQuery());
            double avgStartLatency = totalStartedTasks == 0L ? 0.0 : (double)totalStartLatency / (double)totalStartedTasks;
            return new ExecutorThroughputStatsDTO(address, this.latestMetricValue(queryFactory.pendingTaskQuery()), this.throughputSinceTheBeginning(queryFactory.startedTaskQuery(), intervalInSeconds), this.throughputSinceTheBeginning(queryFactory.completedTaskQuery(), intervalInSeconds), this.throughputSinceTheBeginning(queryFactory.cancelledTaskQuery(), intervalInSeconds), this.latestMetricValue(queryFactory.totalExecutionTimeQuery()), avgStartLatency);
        }).orElse(null);
    }

    private ExecutorThroughputStatsDTO executorStats(ExecutorMetricsQueryFactory queryFactory, String address) {
        CounterAggregates startedTasksAggregates = this.metricsService.computeCounterAggregates(queryFactory.startedTaskQuery());
        long startedTasksIncrement = startedTasksAggregates.getIncrement();
        long startLatencyIncrement = this.metricsService.computeCounterAggregates(queryFactory.totalStartLatencyQuery()).getIncrement();
        double avgStartLatency = startedTasksIncrement == 0L ? 0.0 : (double)startLatencyIncrement / (double)startedTasksIncrement;
        return new ExecutorThroughputStatsDTO(address, this.latestMetricValue(queryFactory.pendingTaskQuery()), startedTasksAggregates.getThroughputPerSecond(), this.metricsService.computeCounterAggregates(queryFactory.completedTaskQuery()).getThroughputPerSecond(), this.metricsService.computeCounterAggregates(queryFactory.cancelledTaskQuery()).getThroughputPerSecond(), this.metricsService.computeCounterAggregates(queryFactory.totalExecutionTimeQuery()).getIncrement(), avgStartLatency);
    }

    private <T, F> List<T> getThroughputStats(String cluster, long time, long interval, QueryFactorySupplier<F> queryFactorySupplier, GetMemberStatsFn<T, F> getMemberStatsSinceBeginningFn, GetMemberStatsFn<T, F> getMemberStatsWithinRangeFn, boolean includeLiteMembers) {
        long end = time > 0L ? time : this.clock.currentTimeMillis();
        long start = end - (interval == 0L ? 30000L : interval);
        Optional<AllState> state = Optional.ofNullable(this.stateManager.getLatestState(cluster));
        ArrayList<Object> result = new ArrayList<Object>();
        List members = this.memberManager.getMemberList(cluster, end);
        for (String member : members) {
            Optional<TimedMemberState> stateEnd = state.map(s -> (TimedMemberState)s.getTimedMemberStates().get(member));
            boolean liteMember = stateEnd.map(TimedMemberState::isLite).orElse(false);
            if (liteMember && !includeLiteMembers) continue;
            Object queryFactory = queryFactorySupplier.get(member, start, end);
            Object stats = interval == 0L ? getMemberStatsSinceBeginningFn.apply(queryFactory, member, end) : getMemberStatsWithinRangeFn.apply(queryFactory, member, end);
            if (stats == null) continue;
            result.add(stats);
        }
        return result;
    }

    private OperationPerformanceAggregates getPerformanceAggregate(Query operationCountQuery, Query totalOperationLatencyQuery) {
        try {
            return this.metricsService.computePerformanceAggregates(operationCountQuery, totalOperationLatencyQuery);
        }
        catch (DataPointSeriesMismatchException e) {
            return OperationPerformanceAggregates.EMPTY;
        }
    }

    private OperationPerformanceAggregates getPerformanceAggregateSinceBeginning(Query operationCountQuery, Query totalOperationLatencyQuery, Query totalMaxOperationLatencyQuery, long intervalInSeconds) {
        long operationCount = this.latestMetricValue(operationCountQuery);
        long totalOperationLatency = this.latestMetricValue(totalOperationLatencyQuery);
        long maxOperationLatency = this.latestMetricValue(totalMaxOperationLatencyQuery);
        double opsPerSecond = (double)operationCount / (double)intervalInSeconds;
        double avgOperationLatency = operationCount == 0L ? 0.0 : (double)totalOperationLatency / (double)operationCount;
        return new OperationPerformanceAggregates((double)maxOperationLatency, avgOperationLatency, opsPerSecond);
    }

    private long latestMetricValue(Query query) {
        return this.metricsService.queryLatestRaw(query).map(DataPointAware::getValue).orElse(0L);
    }

    private double throughputSinceTheBeginning(Query query, long intervalInSeconds) {
        return this.metricsService.queryLatestRaw(query).map(dataPoint -> (double)dataPoint.getValue() / (double)intervalInSeconds).orElse(0.0);
    }
}

