/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.webmonitor.controller.dto.jet.DagDTO;
import com.hazelcast.webmonitor.controller.dto.jet.EdgeInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.ExportedJobSnapshotDTO;
import com.hazelcast.webmonitor.controller.dto.jet.JobInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.MinimizedJobInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.VertexInfoDTO;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.ClusteredJetStatsAggregator;
import com.hazelcast.webmonitor.service.ClusteredJetStatsProvider;
import com.hazelcast.webmonitor.service.DisconnectedFromClusterEvent;
import com.hazelcast.webmonitor.service.MemberRemovedEvent;
import com.hazelcast.webmonitor.service.MembersConfigsParsedEvent;
import com.hazelcast.webmonitor.service.jet.JetService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ClusteredJetStatsAggregator
implements AutoCloseable,
ClusteredJetStatsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusteredJetStatsAggregator.class);
    private static final int THREAD_POOL_SIZE = 4;
    private static final int SCHEDULER_DELAY_SECONDS = 5;
    private final Map<String, ScheduledFuture<?>> scheduledFutures = new ConcurrentHashMap();
    private final Map<String, Lock> clusterLocks = new ConcurrentHashMap();
    private final LoadingCache<String, Map<String, ClusteredJobInfoDTO>> jobsByCluster = Caffeine.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build(key -> Collections.emptyMap());
    private final LoadingCache<String, Map<String, ExportedJobSnapshotDTO>> snapshotsByCluster = Caffeine.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build(key -> Collections.emptyMap());
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(4, new ThreadFactoryBuilder().setNameFormat("ClusteredJetStatsAggregator-%d").build());
    private final JetService jetService;
    private final ClusterManager clusterManager;

    public Map<String, ClusteredJobInfoDTO> getJobs(String cluster) {
        return (Map)this.jobsByCluster.get((Object)cluster);
    }

    public Map<String, ExportedJobSnapshotDTO> getSnapshots(String cluster) {
        return (Map)this.snapshotsByCluster.get((Object)cluster);
    }

    @EventListener
    public void onMembersConfigsParsed(MembersConfigsParsedEvent event) {
        this.adjustFetchingJetStats(event.getCluster());
    }

    @EventListener
    public void onMemberRemoved(MemberRemovedEvent event) {
        this.adjustFetchingJetStats(event.getCluster());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustFetchingJetStats(String cluster) {
        Lock lock = this.clusterLocks.computeIfAbsent(cluster, key -> new ReentrantLock());
        lock.lock();
        try {
            boolean isJetEnabled = this.clusterManager.isJetEnabled(cluster);
            if (isJetEnabled) {
                this.scheduledFutures.putIfAbsent(cluster, this.executorService.scheduleWithFixedDelay(() -> this.fetchJetStats(cluster), 5L, 5L, TimeUnit.SECONDS));
            } else {
                ScheduledFuture future = (ScheduledFuture)this.scheduledFutures.remove(cluster);
                if (future != null) {
                    future.cancel(true);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    @EventListener
    public void disconnectedFromCluster(DisconnectedFromClusterEvent event) {
        String cluster = event.getCluster();
        ScheduledFuture future = (ScheduledFuture)this.scheduledFutures.remove(cluster);
        this.clusterLocks.remove(cluster);
        if (future != null) {
            future.cancel(true);
        }
        this.jobsByCluster.refresh((Object)cluster);
        this.snapshotsByCluster.refresh((Object)cluster);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }

    Map<String, ScheduledFuture<?>> getScheduledFutures() {
        return this.scheduledFutures;
    }

    void fetchJetStats(String cluster) {
        try {
            HashMap<String, ClusteredJobInfoDTO> jobsForCluster = new HashMap<String, ClusteredJobInfoDTO>();
            HashMap<String, ExportedJobSnapshotDTO> snapshotsForCluster = new HashMap<String, ExportedJobSnapshotDTO>();
            for (MinimizedJobInfoDTO job : this.jetService.getJobs(cluster)) {
                JobInfoDTO jobInfo = this.jetService.getJobInfo(cluster, job.getId());
                ArrayList<VertexInfoDTO> vertices = new ArrayList<VertexInfoDTO>();
                ArrayList<EdgeInfoDTO> edges = new ArrayList<EdgeInfoDTO>();
                DagDTO dag = jobInfo.getDag();
                if (dag != null) {
                    for (DagDTO.VertexDTO vertex : dag.getVertices()) {
                        vertices.add(this.jetService.getVertexDetails(cluster, job.getId(), vertex.getName()));
                    }
                    for (DagDTO.EdgeDTO edge : dag.getEdges()) {
                        EdgeInfoDTO edgeInfo = this.jetService.lookUpEdgeInfo(cluster, job.getId(), edge.getFrom(), edge.getFromOrdinal(), edge.getTo(), edge.getToOrdinal());
                        edges.add(edgeInfo);
                    }
                }
                jobsForCluster.put(jobInfo.getId(), new ClusteredJobInfoDTO(jobInfo, vertices, edges));
            }
            for (ExportedJobSnapshotDTO exportedSnapshot : this.jetService.getExportedSnapshots(cluster)) {
                snapshotsForCluster.put(exportedSnapshot.getName(), exportedSnapshot);
            }
            this.jobsByCluster.put((Object)cluster, jobsForCluster);
            this.snapshotsByCluster.put((Object)cluster, snapshotsForCluster);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to aggregate Jet stats for the cluster {}.", (Object)cluster, (Object)exception);
        }
    }

    @ConstructorProperties(value={"jetService", "clusterManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusteredJetStatsAggregator(JetService jetService, ClusterManager clusterManager) {
        this.jetService = jetService;
        this.clusterManager = clusterManager;
    }
}

