/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringListEntryDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringListWithEntriesDTO;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListStatus;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListType;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringStatus;
import com.hazelcast.webmonitor.service.ClusterClientFilteringDTO;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class ClusterClientFilteringDTO
implements IdentifiedDataSerializable {
    private ClientFilteringStatus status;
    private ClientFilteringListType type;
    private List<ClientFilteringListWithEntriesDTO> allClientFilteringLists;
    private String etag;

    public List<ClientFilteringListEntryDTO> getActiveEntries() {
        if (this.status == ClientFilteringStatus.ENABLED) {
            return this.allClientFilteringLists.stream().filter(list -> list.getStatus() == ClientFilteringListStatus.ACTIVE).filter(list -> list.getType() == this.type).map(ClientFilteringListWithEntriesDTO::getEntries).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void writeData(ObjectDataOutput objectDataOutput) throws IOException {
        objectDataOutput.writeObject((Object)this.status);
        objectDataOutput.writeObject((Object)this.type);
        int size = this.allClientFilteringLists == null ? 0 : this.allClientFilteringLists.size();
        objectDataOutput.writeInt(size);
        for (int i = 0; i < size; ++i) {
            ((ClientFilteringListWithEntriesDTO)this.allClientFilteringLists.get(i)).writeData(objectDataOutput);
        }
        objectDataOutput.writeString(this.etag);
    }

    public void readData(ObjectDataInput objectDataInput) throws IOException {
        this.status = (ClientFilteringStatus)objectDataInput.readObject();
        this.type = (ClientFilteringListType)objectDataInput.readObject();
        this.allClientFilteringLists = new ArrayList();
        int size = objectDataInput.readInt();
        for (int i = 0; i < size; ++i) {
            ClientFilteringListWithEntriesDTO newListWithEntries = new ClientFilteringListWithEntriesDTO();
            newListWithEntries.readData(objectDataInput);
            this.allClientFilteringLists.add(newListWithEntries);
        }
        this.etag = objectDataInput.readString();
    }

    public int getFactoryId() {
        return 1;
    }

    public int getClassId() {
        return 1;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ClusterClientFilteringDTOBuilder builder() {
        return new ClusterClientFilteringDTOBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientFilteringStatus getStatus() {
        return this.status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientFilteringListType getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<ClientFilteringListWithEntriesDTO> getAllClientFilteringLists() {
        return this.allClientFilteringLists;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getEtag() {
        return this.etag;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStatus(ClientFilteringStatus status) {
        this.status = status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setType(ClientFilteringListType type) {
        this.type = type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAllClientFilteringLists(List<ClientFilteringListWithEntriesDTO> allClientFilteringLists) {
        this.allClientFilteringLists = allClientFilteringLists;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setEtag(String etag) {
        this.etag = etag;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterClientFilteringDTO)) {
            return false;
        }
        ClusterClientFilteringDTO other = (ClusterClientFilteringDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ClientFilteringStatus this$status = this.getStatus();
        ClientFilteringStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ClientFilteringListType this$type = this.getType();
        ClientFilteringListType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List this$allClientFilteringLists = this.getAllClientFilteringLists();
        List other$allClientFilteringLists = other.getAllClientFilteringLists();
        if (this$allClientFilteringLists == null ? other$allClientFilteringLists != null : !((Object)this$allClientFilteringLists).equals(other$allClientFilteringLists)) {
            return false;
        }
        String this$etag = this.getEtag();
        String other$etag = other.getEtag();
        return !(this$etag == null ? other$etag != null : !this$etag.equals(other$etag));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClusterClientFilteringDTO;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClientFilteringStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ClientFilteringListType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List $allClientFilteringLists = this.getAllClientFilteringLists();
        result = result * 59 + ($allClientFilteringLists == null ? 43 : ((Object)$allClientFilteringLists).hashCode());
        String $etag = this.getEtag();
        result = result * 59 + ($etag == null ? 43 : $etag.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ClusterClientFilteringDTO(status=" + this.getStatus() + ", type=" + this.getType() + ", allClientFilteringLists=" + this.getAllClientFilteringLists() + ", etag=" + this.getEtag() + ")";
    }

    @ConstructorProperties(value={"status", "type", "allClientFilteringLists", "etag"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterClientFilteringDTO(ClientFilteringStatus status, ClientFilteringListType type, List<ClientFilteringListWithEntriesDTO> allClientFilteringLists, String etag) {
        this.status = status;
        this.type = type;
        this.allClientFilteringLists = allClientFilteringLists;
        this.etag = etag;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterClientFilteringDTO() {
    }
}

