/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.dto.client.ClientWithNearCacheDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientsNearCacheIntervalStatsDTO;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Tags;
import com.hazelcast.webmonitor.metrics.imdg.ClientNearCacheMetricsQueryFactory;
import com.hazelcast.webmonitor.model.ClientAttributes;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.service.ClientNearCacheRegistry;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.metrics.DataPointsReceivedEvent;
import com.hazelcast.webmonitor.service.metrics.MetricsService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ClientNearCacheStatsManager {
    private static final List<Long> SUMMARY_INTERVALS_IN_MINUTES = Arrays.asList(1L, 5L, 30L, 60L);
    private static final long MS_IN_MIN = 60000L;
    static final String CLIENT_NEAR_CACHE_METRIC = "nearcache.creationTime";
    private static final String CACHE_NAME_PREFIX = "/hz/";
    private static final int REGISTRY_MAX_SIZE = 10000;
    private static final int REGISTRY_TTL_MIN = 10;
    private final StateManager stateManager;
    private final MetricsService metricsService;
    private final Clock clock;
    private final ClientNearCacheRegistry nearCacheRegistry;

    public ClientNearCacheStatsManager(StateManager stateManager, MetricsService metricsService, Clock clock) {
        this.stateManager = stateManager;
        this.metricsService = metricsService;
        this.clock = clock;
        this.nearCacheRegistry = new ClientNearCacheRegistry(clock, 10000, 10);
    }

    @EventListener
    public void dataPointsReceived(DataPointsReceivedEvent event) {
        MemberIdentifier memberIdent = event.getMemberIdent();
        event.getDataPoints().stream().filter(dataPoint -> "nearcache.creationTime".equals(dataPoint.getName())).map(MetricDataPoint::getTags).forEach(tags -> {
            String clientName = tags.getTag("clientname").map(Tags.Tag::getValue).orElse(null);
            String clientUuid = tags.getTag("mc:client").map(Tags.Tag::getValue).orElse(null);
            String structName = tags.getTag("name").map(Tags.Tag::getValue).orElse(null);
            if (clientUuid != null && structName != null) {
                this.nearCacheRegistry.register(memberIdent.getClusterName(), clientUuid, clientName, ClientNearCacheStatsManager.cleanDataStructureName((String)structName), ClientNearCacheStatsManager.inferDataStructureType((String)structName));
            }
        });
    }

    public List<ClientWithNearCacheDTO> getClientsByDataStructure(String cluster, String structName, InstanceType structType) {
        Map clientStats = this.stateManager.getClientAttributes(cluster);
        if (clientStats.isEmpty()) {
            return Collections.emptyList();
        }
        return this.nearCacheRegistry.getClientsByStruct(cluster, structName, structType).stream().map(clientData -> {
            ClientAttributes stats = (ClientAttributes)clientStats.get(clientData.uuid);
            if (stats == null) {
                return null;
            }
            return ClientWithNearCacheDTO.builder().uuid(clientData.uuid).name(stats.getName()).type(stats.getType()).version(stats.getVersion()).build();
        }).filter(Objects::nonNull).sorted(Comparator.comparing(ClientWithNearCacheDTO::getName)).collect(Collectors.toList());
    }

    public SortedSet<String> getDataStructuresByClient(String cluster, String clientUuid, InstanceType type) {
        return this.nearCacheRegistry.getStructsByClient(cluster, clientUuid, type);
    }

    public List<ClientsNearCacheIntervalStatsDTO> getClientsNearCacheSummaryStats(String cluster, String structName, InstanceType structType, long time) {
        return this.getClientsNearCacheSummaryStats(cluster, structName, structType, time, 0L);
    }

    public List<ClientsNearCacheIntervalStatsDTO> getClientsNearCacheSummaryStats(String cluster, String structName, InstanceType structType, long time, long interval) {
        long endTime = time == 0L ? this.clock.currentTimeMillis() : time - interval;
        return SUMMARY_INTERVALS_IN_MINUTES.stream().map(intv -> this.getClientsNearCacheIntervalStats(cluster, structName, structType, endTime, intv.longValue())).collect(Collectors.toList());
    }

    private ClientsNearCacheIntervalStatsDTO getClientsNearCacheIntervalStats(String cluster, String structName, InstanceType structType, long endTime, long intervalInMinutes) {
        SortedSet clientsData = this.nearCacheRegistry.getClientsByStruct(cluster, structName, structType);
        if (clientsData.isEmpty()) {
            return ClientsNearCacheIntervalStatsDTO.empty((long)intervalInMinutes);
        }
        long startTime = endTime - intervalInMinutes * 60000L;
        long hits = 0L;
        long misses = 0L;
        for (ClientNearCacheRegistry.ClientData clientData : clientsData) {
            ClientNearCacheMetricsQueryFactory queryFactory = new ClientNearCacheMetricsQueryFactory.Builder().cluster(cluster).clientUuid(clientData.uuid).clientName(clientData.name).instanceType(structType).name(structName).start(startTime).end(endTime).build();
            hits += this.metricsService.computeCounterAggregates(queryFactory.hitsQuery()).getIncrement();
            misses += this.metricsService.computeCounterAggregates(queryFactory.missesQuery()).getIncrement();
        }
        long total = hits + misses;
        double effectiveness = total == 0L ? 0.0 : (double)hits / (double)total;
        return new ClientsNearCacheIntervalStatsDTO(intervalInMinutes, hits, misses, effectiveness);
    }

    private static String cleanDataStructureName(String name) {
        if (name.startsWith("/hz/")) {
            return name.substring("/hz/".length());
        }
        return name;
    }

    private static InstanceType inferDataStructureType(String rawDataStructureName) {
        if (rawDataStructureName.startsWith("/hz/")) {
            return InstanceType.CACHE;
        }
        return InstanceType.MAP;
    }
}

