/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.internal.management.dto.CPMemberDTO;
import com.hazelcast.webmonitor.controller.dto.CPSubsystemStatusDTO;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.controller.exception.NoMasterMemberApiException;
import com.hazelcast.webmonitor.controller.exception.OperationFailedApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.MemberStateReceivedEvent;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.Utils;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.memberconfig.ParsedMemberConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CPSubsystemManager {
    private static final int CP_UUID_MAX_CACHE_SIZE = 1000;
    private final StateManager stateManager;
    private final MemberManager memberManager;
    private final OperationDispatcher dispatcher;
    private final Cache<String, String> cpUuidToAddressCache = Caffeine.newBuilder().maximumSize(1000L).build();

    public CPSubsystemStatusDTO getStatus(String cluster) {
        AllState clusterState = this.getClusterState(cluster);
        String master = Utils.getMaster((AllState)clusterState);
        if (master == null) {
            throw new NoMasterMemberApiException(cluster);
        }
        ParsedMemberConfig config = this.memberManager.getParsedConfig(cluster, master);
        int configured = config.getCpMemberCount();
        int reachable = clusterState.getCPMemberUuids().size();
        return CPSubsystemStatusDTO.fromStats((int)configured, (int)reachable);
    }

    public List<CPMemberDTO> getCPMembers(String cluster) {
        if (this.allMembersParticipateInCPSubsystem(cluster)) {
            return (List)this.dispatcher.executeOnCluster(cluster, MCClient::getCPMembers, e -> String.format("Failed to fetch list of CP Subsystem members for cluster %s", cluster));
        }
        Collection lists = this.dispatcher.executeOnAllMembers(cluster, (client, member) -> client.getCPMembers(), (member, e) -> null);
        return lists.stream().filter(Objects::nonNull).findFirst().orElseThrow(() -> new OperationFailedApiException(String.format("Failed to fetch list of CP Subsystem members for cluster %s", cluster)));
    }

    @Async
    @EventListener
    public void memberStateReceived(MemberStateReceivedEvent event) {
        MemberState memberState = event.getState().getMemberState();
        String cpMemberUuid = memberState.getCpMemberUuid();
        if (cpMemberUuid != null) {
            this.cpUuidToAddressCache.put((Object)cpMemberUuid, (Object)memberState.getAddress());
        }
    }

    public String getCpMemberAddress(String cpUuid) {
        return (String)this.cpUuidToAddressCache.get((Object)cpUuid, key -> "unknown");
    }

    private boolean allMembersParticipateInCPSubsystem(String cluster) {
        AllState state = this.getClusterState(cluster);
        return state.getMembers().size() == state.getCPMemberUuids().size();
    }

    public void promoteToCPMember(String cluster, String memberAddress) {
        this.dispatcher.executeOnMember(MemberIdentifier.of((String)cluster, (String)memberAddress), MCClient::promoteToCPMember, e -> String.format("Failed to promote member %s to CP Subsystem for cluster %s", memberAddress, cluster));
    }

    public void removeCPMember(String cluster, UUID cpMemberUuid) {
        this.dispatcher.executeOnCluster(cluster, mcs -> mcs.removeCPMember(cpMemberUuid), e -> String.format("Failed to remove member with UUID %s from CP Subsystem for cluster %s", cpMemberUuid, cluster));
    }

    public void resetCPSubsystem(String cluster) {
        this.dispatcher.executeOnCluster(cluster, MCClient::resetCPSubsystem, e -> String.format("Failed to reset CP Subsystem for cluster %s", cluster));
    }

    private AllState getClusterState(String cluster) {
        AllState clusterState = this.stateManager.getLatestState(cluster);
        if (clusterState == null) {
            throw new NoClusterApiException(cluster);
        }
        return clusterState;
    }

    @ConstructorProperties(value={"stateManager", "memberManager", "dispatcher"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CPSubsystemManager(StateManager stateManager, MemberManager memberManager, OperationDispatcher dispatcher) {
        this.stateManager = stateManager;
        this.memberManager = memberManager;
        this.dispatcher = dispatcher;
    }
}

