/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.dto.cp.AtomicLongStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPDataStructureListingDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPGroupMemberMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPGroupMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPSessionMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPSubsystemMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CountDownLatchStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.FencedLockStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.SemaphoreStatsDTO;
import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.Tags;
import com.hazelcast.webmonitor.metrics.imdg.CPMetricsQueryFactory;
import com.hazelcast.webmonitor.model.CPInstanceType;
import com.hazelcast.webmonitor.service.CPStatsRegistry;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.metrics.DataPointsReceivedEvent;
import com.hazelcast.webmonitor.service.metrics.MetricsService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class CPStatsService {
    private static final long LOOKUP_INTERVAL_MS = 60000L;
    private static final int REGISTRY_MAX_SIZE = 100000;
    private static final int REGISTRY_TTL_MIN = 5;
    private final MetricsService metricsService;
    private final Clock clock;
    private final MemberManager memberManager;
    private final CPStatsRegistry statsRegistry;

    public CPStatsService(MetricsService metricsService, Clock clock, MemberManager memberManager, StateManager stateManager) {
        this.metricsService = metricsService;
        this.clock = clock;
        this.memberManager = memberManager;
        this.statsRegistry = new CPStatsRegistry(stateManager, clock, 100000, 5);
    }

    @EventListener
    public void dataPointReceived(DataPointsReceivedEvent event) {
        MemberIdentifier memberIdent = event.getMemberIdent();
        event.getDataPoints().forEach(dataPoint -> {
            String dataPointName = dataPoint.getName();
            if (dataPointName.startsWith("raft.group")) {
                this.handleGroupMetric(dataPoint, memberIdent);
            } else if (dataPointName.startsWith("cp.session")) {
                this.statsRegistry.processSessionDataPoint(dataPoint, memberIdent);
            } else if (this.inferInstanceTypeFromMetricName(dataPointName) != null) {
                this.handleDataStructureMetric(dataPoint, memberIdent);
            }
        });
    }

    private void handleGroupMetric(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        Optional<String> groupId = dataPoint.getTags().getTag("groupId").map(Tags.Tag::getValue);
        if (groupId.isPresent()) {
            String groupName = dataPoint.getTags().getTag("name").map(Tags.Tag::getValue).orElse(null);
            String member = memberIdent.getMemberAddress();
            String memberRole = dataPoint.getTags().getTag("role").map(Tags.Tag::getValue).orElse(null);
            this.statsRegistry.registerGroup(memberIdent.getClusterName(), groupId.get(), groupName, member, memberRole);
        }
    }

    private void handleDataStructureMetric(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        String metricName = dataPoint.getName();
        CPInstanceType structType = this.inferInstanceTypeFromMetricName(metricName);
        if (structType == null) {
            return;
        }
        String structName = dataPoint.getTags().getTag("name").map(Tags.Tag::getValue).orElse(null);
        String structGroup = dataPoint.getTags().getTag("group").map(Tags.Tag::getValue).orElse(null);
        if (structName != null && structGroup != null) {
            structName = structName + "@" + structGroup;
            this.statsRegistry.registerDataStructure(memberIdent.getClusterName(), structType, structName, structGroup);
        }
    }

    private CPInstanceType inferInstanceTypeFromMetricName(String s) {
        if (s.startsWith("cp.atomiclong")) {
            return CPInstanceType.ATOMIC_LONG;
        }
        if (s.startsWith("cp.semaphore")) {
            return CPInstanceType.SEMAPHORE;
        }
        if (s.startsWith("cp.atomicref")) {
            return CPInstanceType.ATOMIC_REFERENCE;
        }
        if (s.startsWith("cp.countdownlatch")) {
            return CPInstanceType.COUNTDOWN_LATCH;
        }
        if (s.startsWith("cp.lock")) {
            return CPInstanceType.FENCED_LOCK;
        }
        return null;
    }

    public List<CPSubsystemMetricsDTO> subsystemMetrics(String cluster) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        ArrayList<CPSubsystemMetricsDTO> results = new ArrayList<CPSubsystemMetricsDTO>();
        List members = this.memberManager.getMemberList(cluster);
        for (String member : members) {
            CPMetricsQueryFactory queryFactory = new CPMetricsQueryFactory.Builder().cluster(cluster).member(member).start(start).end(end).build();
            long nodes = this.queryLatest(queryFactory.subsystemNodes());
            long groups = this.queryLatest(queryFactory.subsystemGroups());
            long destroyedGroups = this.queryLatest(queryFactory.subsystemDestroyedGroupIds());
            long activeMembers = this.queryLatest(queryFactory.subsystemActiveMembers());
            long missingMembers = this.queryLatest(queryFactory.subsystemMissingMembers());
            results.add(CPSubsystemMetricsDTO.builder().member(member).nodes(nodes).groups(groups).destroyedGroups(destroyedGroups).activeMembers(activeMembers).missingMembers(missingMembers).build());
        }
        return results;
    }

    private long getEndTime(long time) {
        return time == 0L ? this.clock.currentTimeMillis() : time;
    }

    public List<CPGroupMetricsDTO> groupMetrics(String cluster) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        ArrayList<CPGroupMetricsDTO> results = new ArrayList<CPGroupMetricsDTO>();
        for (CPStatsRegistry.GroupRecord rec : this.statsRegistry.getKnownGroups(cluster)) {
            CPGroupMetricsDTO group = CPGroupMetricsDTO.builder().groupName(rec.getGroupName()).groupId(rec.getGroupId()).members(new ArrayList()).build();
            rec.getMembers().forEach((memberAddr, memberRole) -> {
                CPMetricsQueryFactory queryFactory = new CPMetricsQueryFactory.Builder().cluster(cluster).member(memberAddr).start(start).end(end).name(rec.getGroupName()).groupId(rec.getGroupId()).role(memberRole).build();
                long term = this.queryLatest(queryFactory.groupTerm());
                long commitIndex = this.queryLatest(queryFactory.groupCommitIndex());
                long lastApplied = this.queryLatest(queryFactory.groupLastApplied());
                long lastLogTerm = this.queryLatest(queryFactory.groupLastLogTerm());
                long snapshotIndex = this.queryLatest(queryFactory.groupSnapshotIndex());
                long lastLogIndex = this.queryLatest(queryFactory.groupLastLogIndex());
                long availableLogCapacity = this.queryLatest(queryFactory.groupAvailableLogCapacity());
                CPGroupMemberMetricsDTO metric = CPGroupMemberMetricsDTO.builder().member(memberAddr).role(memberRole).term(term).commitIndex(commitIndex).lastApplied(lastApplied).lastLogTerm(lastLogTerm).snapshotIndex(snapshotIndex).lastLogIndex(lastLogIndex).availableLogCapacity(availableLogCapacity).build();
                group.getMembers().add(metric);
            });
            results.add(group);
        }
        return results;
    }

    public List<CPSessionMetricsDTO> sessionMetrics(String cluster) {
        return this.statsRegistry.getKnownSessions(cluster).stream().map(rec -> CPSessionMetricsDTO.builder().id(rec.getId()).sessionId(rec.getSessionId()).member(rec.getMember()).endpoint(rec.getEndpoint()).endpointName(rec.getEndpointName()).endpointType(rec.getEndpointType()).version(rec.getVersion()).creationTime(rec.getCreationTime()).expirationTime(rec.getExpirationTime()).build()).collect(Collectors.toList());
    }

    public List<CPDataStructureListingDTO> structsByType(String cluster, CPInstanceType dataStructureType) {
        return this.statsRegistry.getKnownStructsByType(cluster, dataStructureType);
    }

    private String getMemberToQuery(String cluster) {
        List members = this.memberManager.getMemberList(cluster);
        return (String)members.get(0);
    }

    private long queryLatest(Query query) {
        return this.queryLatest(query, 0L);
    }

    private long queryLatest(Query query, long defaultValue) {
        return this.metricsService.queryLatestRaw(query).map(DataPointAware::getValue).orElse(defaultValue);
    }

    Pair<String, String> parseNameAndGroup(String instanceName) {
        String onlyName = instanceName;
        String groupName = "default";
        String[] parts = instanceName.split("@");
        if (parts.length == 2) {
            onlyName = parts[0];
            groupName = parts[1];
        }
        return Pair.of((Object)onlyName, (Object)groupName);
    }

    public AtomicLongStatsDTO getAtomicLongStats(String cluster, String instanceName, long time) {
        CPMetricsQueryFactory queryFactory = this.prepareQueryFactory(time, instanceName, cluster);
        long value = this.queryLatest(queryFactory.atomicLongValue());
        return AtomicLongStatsDTO.builder().name(instanceName).value(value).build();
    }

    private CPMetricsQueryFactory prepareQueryFactory(long time, String instanceName, String cluster) {
        long end = this.getEndTime(time);
        long start = end - 60000L;
        Pair nameAndGroup = this.parseNameAndGroup(instanceName);
        String name = (String)nameAndGroup.getKey();
        String group = (String)nameAndGroup.getValue();
        String member = this.getMemberToQuery(cluster);
        return new CPMetricsQueryFactory.Builder().cluster(cluster).member(member).start(start).end(end).id(instanceName).name(name).group(group).build();
    }

    public SemaphoreStatsDTO getSemaphoreStats(String cluster, String instanceName, long time) {
        CPMetricsQueryFactory queryFactory = this.prepareQueryFactory(time, instanceName, cluster);
        long initialized = this.queryLatest(queryFactory.semaphoreInitialized());
        long available = this.queryLatest(queryFactory.semaphoreAvailable());
        return SemaphoreStatsDTO.builder().name(instanceName).initialized(initialized).available(available).build();
    }

    public FencedLockStatsDTO getFencedLockStats(String cluster, String instanceName, long time) {
        CPMetricsQueryFactory queryFactory = this.prepareQueryFactory(time, instanceName, cluster);
        long lockCount = this.queryLatest(queryFactory.fencedLockLockCount());
        long acquireLimit = this.queryLatest(queryFactory.fencedLockAcquireLimit());
        long ownerSessionId = this.queryLatest(queryFactory.fencedLockOwnerSessionId());
        long owner = this.queryLatest(queryFactory.fencedLockOwner());
        return FencedLockStatsDTO.builder().name(instanceName).lockCount(lockCount).acquireLimit(acquireLimit).ownerSessionId(ownerSessionId).owner(owner).build();
    }

    public CountDownLatchStatsDTO getCountdownLatchStats(String cluster, String instanceName, long time) {
        CPMetricsQueryFactory queryFactory = this.prepareQueryFactory(time, instanceName, cluster);
        long round = this.queryLatest(queryFactory.countdownLatchRound());
        long count = this.queryLatest(queryFactory.countdownLatchCount());
        long remaining = this.queryLatest(queryFactory.countdownLatchRemaining());
        return CountDownLatchStatsDTO.builder().name(instanceName).round(round).count(count).remaining(remaining).build();
    }
}

