/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.ldap;

import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.security.spi.impl.PersistentSecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.BuiltInKeystorePersistentLdapConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.ExistingKeystorePersistentLdapConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.LdapConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.NoKeystorePersistentLdapConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.PersistentLdapConfigFactory;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.utils.StringUtil;
import org.jdbi.v3.core.Jdbi;

public class PersistentLdapConfigFactory {
    public static final String DEFAULT_BUILTIN_KEYSTORE_FILE_NAME = "mc.jceks";
    private final Jdbi jdbi;
    private final GroupedSettingsDAO groupedSettingsDAO;
    private String builtinKeystorePassword;
    private String builtinKeystoreFile;
    private final Mode mode;
    private String existingKeystorePath;
    private String existingKeystorePass;
    private String existingKeystoreType;
    private String existingKeystoreProvider;

    PersistentLdapConfigFactory(HomeDirectoryProvider homeDirectoryProvider, Jdbi jdbi, GroupedSettingsDAO groupedSettingsDAO, MCConfigurationProperties mcProperties) {
        this.jdbi = jdbi;
        this.groupedSettingsDAO = groupedSettingsDAO;
        if (mcProperties.isUseExistingKeyStore()) {
            this.mode = Mode.EXISTING_KEYSTORE;
            this.existingKeystorePath = mcProperties.getExistingKeyStore().getPath();
            this.existingKeystorePass = mcProperties.getExistingKeyStore().getPass();
            this.existingKeystoreType = mcProperties.getExistingKeyStore().getType();
            this.existingKeystoreProvider = mcProperties.getExistingKeyStore().getProvider();
        } else {
            this.builtinKeystorePassword = mcProperties.getKeyStore().getPassword();
            if (this.shouldUseBuiltInKeystore()) {
                this.mode = Mode.BUILTIN_KEYSTORE;
                String keyStorePath = mcProperties.getKeyStore().getPath();
                this.builtinKeystoreFile = !StringUtil.isNullOrEmptyAfterTrim((String)keyStorePath) ? keyStorePath : homeDirectoryProvider.get().resolve(DEFAULT_BUILTIN_KEYSTORE_FILE_NAME).toString();
            } else {
                this.mode = Mode.NO_KEYSTORE;
            }
        }
    }

    PersistentSecurityProviderConfig<LdapConfig> create() {
        switch (1.$SwitchMap$com$hazelcast$webmonitor$security$spi$impl$ldap$PersistentLdapConfigFactory$Mode[this.mode.ordinal()]) {
            case 1: {
                return new ExistingKeystorePersistentLdapConfig(this.jdbi, this.groupedSettingsDAO, this.existingKeystorePath, this.existingKeystorePass, this.existingKeystoreType, this.existingKeystoreProvider);
            }
            case 2: {
                return new BuiltInKeystorePersistentLdapConfig(this.jdbi, this.groupedSettingsDAO, this.builtinKeystoreFile, this.builtinKeystorePassword);
            }
            case 3: {
                return new NoKeystorePersistentLdapConfig(this.groupedSettingsDAO);
            }
        }
        throw new IllegalStateException("Unrecognized LDAP config persistence mode");
    }

    private boolean shouldUseBuiltInKeystore() {
        return this.builtinKeystorePassword != null;
    }
}

