/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl;

import com.hazelcast.webmonitor.configreplacer.ConfigReplacerHelper;
import com.hazelcast.webmonitor.model.sql.SettingModel;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SecurityConfigurationManager {
    public static final String SECURITY_PROVIDER_SETTINGS_GROUP_NAME = "securityProvider";
    public static final String CURRENT_SECURITY_PROVIDER_PROPERTY = "currentProvider";
    private final SettingsDAO settingsDAO;
    private final List<SecurityProviderEventListener> listeners;

    public SecurityConfigurationManager(SettingsDAO settingsDAO) {
        this(settingsDAO, Collections.emptyList());
    }

    public SecurityConfigurationManager(SettingsDAO settingsDAO, Collection<SecurityProviderEventListener> listeners) {
        this.settingsDAO = settingsDAO;
        this.listeners = Collections.unmodifiableList(new ArrayList<SecurityProviderEventListener>(listeners));
    }

    public String getCurrentSecurityProviderName() {
        return this.getProperty(CURRENT_SECURITY_PROVIDER_PROPERTY);
    }

    public void setCurrentSecurityProviderName(String provider) {
        this.settingsDAO.insertOrUpdate(new SettingModel(CURRENT_SECURITY_PROVIDER_PROPERTY, provider));
        this.listeners.forEach(SecurityProviderEventListener::securityProviderSet);
    }

    public void resetCurrentSecurityProviderName() {
        this.settingsDAO.deleteByName(CURRENT_SECURITY_PROVIDER_PROPERTY);
    }

    private String getProperty(String name) {
        return ConfigReplacerHelper.replace((String)name, (String)this.settingsDAO.findByName(name).map(SettingModel::getValue).orElse(null));
    }
}

