/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.security.LoginDisabledException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class DisableLoginStrategy
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DisableLoginStrategy.class);
    private final Cache<String, AtomicLong> failedLoginCountCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();
    private final ConcurrentHashMap<String, Long> disabledLogins = new ConcurrentHashMap();
    private final int initialPeriod;
    private final int periodMultiplier;
    private final int maxAttempts;
    private final int maxPeriod;
    private final ScheduledThreadPoolExecutor executor;

    DisableLoginStrategy(MCConfigurationProperties mcProperties) {
        this.initialPeriod = mcProperties.getInitialDisableLoginPeriod();
        this.periodMultiplier = mcProperties.getDisableLoginPeriodMultiplier();
        this.maxAttempts = mcProperties.getFailedAttemptsBeforeDisableLogin();
        this.maxPeriod = mcProperties.getMaxDisableLoginPeriod();
        log.info("Login will be disabled for " + this.initialPeriod + " seconds after " + this.maxAttempts + " failed login attempts. For every " + this.maxAttempts + " consecutive failed login attempts, disable period will be multiplied by " + this.periodMultiplier + ".");
        if (this.maxPeriod != Integer.MAX_VALUE) {
            log.info("Maximum login disable period is configured to be " + this.maxPeriod + " seconds.");
        }
        this.executor = new ScheduledThreadPoolExecutor(1, arg_0 -> this.newScheduledCleanupThread(arg_0));
        this.executor.scheduleAtFixedRate(() -> {
            log.info("Starting scheduled disabled login cleanup.");
            this.failedLoginCountCache.cleanUp();
            long now = System.currentTimeMillis();
            HashSet toBeDeleted = new HashSet();
            for (Map.Entry entry : this.disabledLogins.entrySet()) {
                long timestamp = (Long)entry.getValue();
                if (timestamp >= now) continue;
                toBeDeleted.add(entry);
            }
            for (Map.Entry entry : toBeDeleted) {
                this.disabledLogins.remove(entry.getKey(), entry.getValue());
            }
            log.info("Finished scheduled disabled login cleanup.");
        }, 1L, 1L, TimeUnit.HOURS);
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    void checkIfDisabled(String username) {
        Long disabledLoginTimestamp = (Long)this.disabledLogins.get(username);
        if (disabledLoginTimestamp != null) {
            long disableExpirationMillis = disabledLoginTimestamp - System.currentTimeMillis();
            if (disableExpirationMillis > 0L) {
                throw new LoginDisabledException(disableExpirationMillis);
            }
            this.disabledLogins.remove(username);
        }
    }

    void successfulLogin(String username) {
        this.disabledLogins.remove(username);
        this.failedLoginCountCache.invalidate((Object)username);
    }

    void failedLoginAttempt(String username) {
        long count;
        AtomicLong existingCount = this.failedLoginCountCache.asMap().putIfAbsent(username, new AtomicLong(1L));
        long l = count = existingCount != null ? existingCount.incrementAndGet() : 1L;
        if (count % (long)this.maxAttempts == 0L) {
            long seconds = Math.min((long)this.maxPeriod, (long)Math.pow(this.periodMultiplier, count / (long)this.maxAttempts - 1L) * (long)this.initialPeriod);
            long millis = TimeUnit.SECONDS.toMillis(seconds);
            this.disabledLogins.put(username, System.currentTimeMillis() + millis);
            throw new LoginDisabledException(millis);
        }
    }

    private Thread newScheduledCleanupThread(Runnable target) {
        Thread thread = new Thread(target, "DisabledLoginCleanupThread");
        thread.setDaemon(true);
        return thread;
    }
}

