/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.ClusterModel;
import java.util.List;
import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClusterDAO {
    private final Jdbi jdbi;

    @Autowired
    public ClusterDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    public void insert(ClusterModel cluster) {
        this.jdbi.useHandle(handle -> this.insertTx(handle, cluster));
    }

    public void insertTx(Handle handle, ClusterModel cluster) {
        ((Update)((Update)((Update)((Update)((Update)handle.createUpdate("insert into clusters (name, member_addresses, client_config_type, client_config, enabled) values (:name, :member_addresses, :client_config_type, :client_config, :enabled)").bind("name", cluster.getName())).bind("member_addresses", (Object)cluster.getMemberAddresses())).bind("client_config_type", (Object)cluster.getClientConfigType())).bind("client_config", cluster.getClientConfig())).bind("enabled", cluster.isEnabled())).execute();
    }

    public int update(String name, ClusterModel cluster) {
        return (Integer)this.jdbi.withHandle(handle -> this.updateTx(handle, name, cluster));
    }

    public int updateTx(Handle handle, String name, ClusterModel cluster) {
        return ((Update)((Update)((Update)((Update)((Update)handle.createUpdate("UPDATE clusters SET member_addresses = :member_addresses, client_config_type = :client_config_type, client_config = :client_config, enabled = :enabled WHERE name = :name").bind("name", name)).bind("member_addresses", (Object)cluster.getMemberAddresses())).bind("client_config_type", (Object)cluster.getClientConfigType())).bind("client_config", cluster.getClientConfig())).bind("enabled", cluster.isEnabled())).execute();
    }

    public void delete(String cluster) {
        this.jdbi.useHandle(handle -> this.deleteTx(handle, cluster));
    }

    public void deleteTx(Handle handle, String cluster) {
        ((Update)handle.createUpdate("DELETE FROM clusters WHERE name = :name").bind("name", cluster)).execute();
    }

    public Optional<ClusterModel> findByName(String name) {
        return (Optional)this.jdbi.withHandle(handle -> this.findByNameTx(handle, name));
    }

    public Optional<ClusterModel> findByNameTx(Handle handle, String name) {
        return ((Query)handle.createQuery("select * from clusters where name = :name").bind("name", name)).mapToBean(ClusterModel.class).findFirst();
    }

    public List<String> findAllClusterNames() {
        return (List)this.jdbi.withHandle(handle -> handle.createQuery("select name from clusters order by name").mapTo(String.class).list());
    }

    public List<ClusterModel> findEnabled() {
        return (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from clusters where enabled = true order by name").mapToBean(ClusterModel.class).list());
    }

    public int updateEnableStatus(String name, boolean enabled) {
        return (Integer)this.jdbi.withHandle(handle -> ((Update)((Update)handle.createUpdate("UPDATE clusters SET enabled = :enabled WHERE name = :name").bind("name", name)).bind("enabled", enabled)).execute());
    }

    public List<ClusterModel> findAllClusters() {
        return (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from clusters").mapToBean(ClusterModel.class).list());
    }
}

