/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.client.ClientFilteringConfigModel;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListEntryModel;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListModel;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListStatus;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListType;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListWithEntries;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringStatus;
import com.hazelcast.webmonitor.model.sql.client.DeployedClientFilteringConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClientFilteringDAO {
    private static final String SELECT_JOINED_ALL = "select c.id             c_id, c.cluster        c_cluster, c.status         c_status, c.type           c_type, c.etag           c_etag, l.id             l_id, l.cluster        l_cluster, l.name           l_name, l.status         l_status, l.type           l_type, e.id             e_id, e.list_id        e_list_id, e.type           e_type, e.value          e_value from client_filtering_configs c left join client_filtering_lists l on c.cluster = l.cluster left join client_filtering_list_entries e on l.id = e.list_id ";
    private static final String SELECT_ALL_FOR_CLUSTER = "select c.id             c_id, c.cluster        c_cluster, c.status         c_status, c.type           c_type, c.etag           c_etag, l.id             l_id, l.cluster        l_cluster, l.name           l_name, l.status         l_status, l.type           l_type, e.id             e_id, e.list_id        e_list_id, e.type           e_type, e.value          e_value from client_filtering_configs c left join client_filtering_lists l on c.cluster = l.cluster left join client_filtering_list_entries e on l.id = e.list_id where c.cluster = :cluster";
    private static final String SELECT_ALL_LISTS_FOR_CLUSTER = "select c.id             c_id, c.cluster        c_cluster, c.status         c_status, c.type           c_type, c.etag           c_etag, l.id             l_id, l.cluster        l_cluster, l.name           l_name, l.status         l_status, l.type           l_type, e.id             e_id, e.list_id        e_list_id, e.type           e_type, e.value          e_value from client_filtering_configs c left join client_filtering_lists l on c.cluster = l.cluster left join client_filtering_list_entries e on l.id = e.list_id where l.cluster = :cluster order by l.name, e.type, e.value";
    private static final String SELECT_LISTS_FOR_CLUSTER_BY_TYPE_AND_STATUS = "select c.id             c_id, c.cluster        c_cluster, c.status         c_status, c.type           c_type, c.etag           c_etag, l.id             l_id, l.cluster        l_cluster, l.name           l_name, l.status         l_status, l.type           l_type, e.id             e_id, e.list_id        e_list_id, e.type           e_type, e.value          e_value from client_filtering_configs c left join client_filtering_lists l on c.cluster = l.cluster left join client_filtering_list_entries e on l.id = e.list_id where l.cluster = :cluster and l.type = :type and l.status = :status order by l.name, e.type, e.value";
    private static final String SELECT_LIST_BY_ID = "select c.id             c_id, c.cluster        c_cluster, c.status         c_status, c.type           c_type, c.etag           c_etag, l.id             l_id, l.cluster        l_cluster, l.name           l_name, l.status         l_status, l.type           l_type, e.id             e_id, e.list_id        e_list_id, e.type           e_type, e.value          e_value from client_filtering_configs c left join client_filtering_lists l on c.cluster = l.cluster left join client_filtering_list_entries e on l.id = e.list_id where l.id = :id";
    private final BiConsumer<Map<Long, ClientFilteringListWithEntries>, RowView> listWithEntriesReducer = (map, rowView) -> {
        ClientFilteringListWithEntries clientFilteringList = map.computeIfAbsent((Long)rowView.getColumn("l_id", Long.class), id -> (ClientFilteringListWithEntries)rowView.getRow(ClientFilteringListWithEntries.class));
        if (clientFilteringList.getEntries() == null) {
            clientFilteringList.setEntries(new ArrayList());
        }
        if (rowView.getColumn("e_id", Long.class) != null) {
            clientFilteringList.getEntries().add((ClientFilteringListEntryModel)rowView.getRow(ClientFilteringListEntryModel.class));
        }
    };
    private final BiConsumer<Map<Long, DeployedClientFilteringConfig>, RowView> deployedClientFilteringConfigReducer = (map, rowView) -> {
        ClientFilteringListModel model;
        DeployedClientFilteringConfig clientFilteringList = map.computeIfAbsent((Long)rowView.getColumn("c_id", Long.class), id -> (DeployedClientFilteringConfig)rowView.getRow(DeployedClientFilteringConfig.class));
        if (clientFilteringList.getEntries() == null) {
            clientFilteringList.setEntries(new ArrayList());
        }
        if (clientFilteringList.getStatus() == ClientFilteringStatus.DISABLED) {
            return;
        }
        if (rowView.getColumn("l_id", Long.class) != null && (model = (ClientFilteringListModel)rowView.getRow(ClientFilteringListModel.class)).getStatus() == ClientFilteringListStatus.ACTIVE && clientFilteringList.getType() == model.getType() && rowView.getColumn("e_id", Long.class) != null) {
            clientFilteringList.getEntries().add((ClientFilteringListEntryModel)rowView.getRow(ClientFilteringListEntryModel.class));
        }
    };
    private final Jdbi jdbi;

    @Autowired
    public ClientFilteringDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    public Long insert(ClientFilteringListModel clientFilteringList) {
        return (Long)this.jdbi.withHandle(handle -> this.insertTx(handle, clientFilteringList));
    }

    public Long insertTx(Handle handle, ClientFilteringListModel list) {
        return (Long)((Update)((Update)((Update)((Update)handle.createUpdate("insert into client_filtering_lists (cluster, name, status, type) values (:cluster, :name, :status, :type)").bind("cluster", list.getCluster())).bind("name", list.getName())).bind("status", (Object)list.getStatus())).bind("type", (Object)list.getType())).executeAndReturnGeneratedKeys(new String[0]).mapTo(Long.class).one();
    }

    public void update(ClientFilteringListModel list) {
        this.jdbi.useHandle(handle -> this.updateTx(handle, list));
    }

    public void updateTx(Handle handle, ClientFilteringListModel list) {
        ((Update)((Update)((Update)((Update)handle.createUpdate("update client_filtering_lists set name = :name, status = :status, type = :type where id = :id").bind("id", list.getId())).bind("name", list.getName())).bind("status", (Object)list.getStatus())).bind("type", (Object)list.getType())).execute();
    }

    public void delete(Long id) {
        this.jdbi.useHandle(handle -> this.deleteTx(handle, id));
    }

    public void deleteTx(Handle handle, Long id) {
        ((Update)handle.createUpdate("delete from client_filtering_lists where id = :id").bind("id", id)).execute();
    }

    public Optional<ClientFilteringListModel> findById(Long id) {
        return (Optional)this.jdbi.withHandle(handle -> ((Query)handle.createQuery("select * from client_filtering_lists where id = :id").bind("id", id)).mapToBean(ClientFilteringListModel.class).findFirst());
    }

    public Optional<ClientFilteringConfigModel> findClientFilteringConfig(String cluster) {
        return (Optional)this.jdbi.withHandle(handle -> this.findClientFilteringConfigTx(handle, cluster));
    }

    public Optional<ClientFilteringConfigModel> findClientFilteringConfigTx(Handle handle, String cluster) {
        return ((Query)handle.createQuery("select * from client_filtering_configs where cluster = :cluster").bind("cluster", cluster)).mapToBean(ClientFilteringConfigModel.class).findFirst();
    }

    public List<ClientFilteringListWithEntries> findAllWithEntries(String cluster) {
        return (List)this.jdbi.withHandle(handle -> ((Query)((Query)((Query)handle.createQuery(SELECT_ALL_LISTS_FOR_CLUSTER).bind("cluster", cluster)).registerRowMapper(BeanMapper.factory(ClientFilteringListWithEntries.class, (String)"l"))).registerRowMapper(BeanMapper.factory(ClientFilteringListEntryModel.class, (String)"e"))).reduceRows(this.listWithEntriesReducer).collect(Collectors.toList()));
    }

    public List<ClientFilteringListWithEntries> findAllFilteredWithEntries(String cluster, ClientFilteringListStatus status, ClientFilteringListType type) {
        return (List)this.jdbi.withHandle(handle -> ((Query)((Query)((Query)((Query)((Query)handle.createQuery(SELECT_LISTS_FOR_CLUSTER_BY_TYPE_AND_STATUS).bind("cluster", cluster)).bind("status", status.toString())).bind("type", type.toString())).registerRowMapper(BeanMapper.factory(ClientFilteringListWithEntries.class, (String)"l"))).registerRowMapper(BeanMapper.factory(ClientFilteringListEntryModel.class, (String)"e"))).reduceRows(this.listWithEntriesReducer).collect(Collectors.toList()));
    }

    public Optional<ClientFilteringListWithEntries> findWithEntries(Long id) {
        return (Optional)this.jdbi.withHandle(handle -> ((Query)((Query)((Query)handle.createQuery(SELECT_LIST_BY_ID).bind("id", id)).registerRowMapper(BeanMapper.factory(ClientFilteringListWithEntries.class, (String)"l"))).registerRowMapper(BeanMapper.factory(ClientFilteringListEntryModel.class, (String)"e"))).reduceRows(this.listWithEntriesReducer).findFirst());
    }

    public Optional<DeployedClientFilteringConfig> findDeployedWithEntries(String cluster) {
        return (Optional)this.jdbi.withHandle(handle -> ((Query)((Query)((Query)((Query)handle.createQuery(SELECT_ALL_FOR_CLUSTER).bind("cluster", cluster)).registerRowMapper(BeanMapper.factory(DeployedClientFilteringConfig.class, (String)"c"))).registerRowMapper(BeanMapper.factory(ClientFilteringListModel.class, (String)"l"))).registerRowMapper(BeanMapper.factory(ClientFilteringListEntryModel.class, (String)"e"))).reduceRows(this.deployedClientFilteringConfigReducer).findFirst());
    }

    public void insertEntry(ClientFilteringListEntryModel entry) {
        this.jdbi.useHandle(handle -> this.insertEntryTx(handle, entry));
    }

    public void insertEntryTx(Handle handle, ClientFilteringListEntryModel entry) {
        ((Update)((Update)((Update)handle.createUpdate("insert into client_filtering_list_entries (list_id, type, value) values (:listId, :type, :value)").bind("listId", entry.getListId())).bind("type", (Object)entry.getType())).bind("value", entry.getValue())).execute();
    }

    public void deleteAllEntries(Long listId) {
        this.jdbi.useHandle(handle -> this.deleteAllEntriesTx(handle, listId));
    }

    public void deleteAllEntriesTx(Handle handle, Long listId) {
        ((Update)handle.createUpdate("delete from client_filtering_list_entries where list_id = :listId").bind("listId", listId)).execute();
    }

    public void insertConfig(ClientFilteringConfigModel config) {
        this.jdbi.useHandle(handle -> this.insertConfigTx(handle, config));
    }

    public void insertConfigTx(Handle handle, ClientFilteringConfigModel config) {
        ((Update)((Update)((Update)((Update)handle.createUpdate("insert into client_filtering_configs (cluster, status, type, etag) values (:cluster, :status, :type, :etag)").bind("cluster", config.getCluster())).bind("type", (Object)config.getType())).bind("status", (Object)config.getStatus())).bind("etag", config.getEtag())).execute();
    }

    public void updateConfig(ClientFilteringConfigModel config) {
        this.jdbi.useHandle(handle -> this.updateConfigTx(handle, config));
    }

    public void updateConfigTx(Handle handle, ClientFilteringConfigModel config) {
        ((Update)((Update)((Update)((Update)((Update)handle.createUpdate("update client_filtering_configs set cluster = :cluster, status = :status, type = :type, etag = :etag where id = :id").bind("id", config.getId())).bind("cluster", config.getCluster())).bind("type", (Object)config.getType())).bind("status", (Object)config.getStatus())).bind("etag", config.getEtag())).execute();
    }

    public void deleteConfig(String cluster) {
        this.jdbi.useHandle(handle -> this.deleteConfigTx(handle, cluster));
    }

    public void deleteConfigTx(Handle handle, String cluster) {
        ((Update)handle.createUpdate("delete client_filtering_configs where cluster = :cluster").bind("cluster", cluster)).execute();
    }

    public Optional<ClientFilteringConfigModel> findConfigByCluster(String cluster) {
        return (Optional)this.jdbi.withHandle(handle -> ((Query)handle.createQuery("select * from client_filtering_configs where cluster = :cluster").bind("cluster", cluster)).mapToBean(ClientFilteringConfigModel.class).findFirst());
    }
}

