/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.client.ClientModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import lombok.Generated;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.springframework.stereotype.Repository;

@Repository
public class ClientDAO {
    private final Jdbi jdbi;

    public void batchUpdate(List<ClientModel> clientModels) {
        this.jdbi.useTransaction(tx -> {
            PreparedBatch batch = tx.prepareBatch("MERGE INTO clients(cluster, name, uuid, first_seen_at, last_seen_at)  VALUES (:cluster, :name, :uuid, :firstSeenAt, :lastSeenAt)");
            clientModels.forEach(clientModel -> ((PreparedBatch)batch.bindBean(clientModel)).add());
            batch.execute();
        });
    }

    public List<ClientModel> findClientsByCluster(String clusterName) {
        return (List)this.jdbi.withHandle(tx -> ((Query)tx.createQuery("SELECT * FROM clients WHERE cluster = :cluster").bind("cluster", clusterName)).mapToBean(ClientModel.class).list());
    }

    public List<ClientModel> findClientsInInterval(String cluster, OffsetDateTime from, OffsetDateTime to) {
        return (List)this.jdbi.withHandle(handle -> ((Query)((Query)((Query)handle.createQuery("SELECT * FROM clients  WHERE ((:from <= first_seen_at AND first_seen_at <= :to) OR (:from <= nvl(last_seen_at, now()) AND nvl(last_seen_at, now()) <= :to) OR (first_seen_at <= :from AND :to <= nvl(last_seen_at, now()))) AND cluster = :cluster").bind("from", (Object)from)).bind("to", (Object)to)).bind("cluster", cluster)).mapToBean(ClientModel.class).list());
    }

    public void deleteClientsLastSeenBefore(OffsetDateTime dateTime) {
        this.jdbi.withHandle(handle -> handle.execute("DELETE FROM clients WHERE last_seen_at < ?", new Object[]{dateTime}));
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

