/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.model.sql;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="array is required for JDBI mapping")
public class ClusterModel {
    private String name;
    private String[] memberAddresses;
    private ClientConfigType clientConfigType;
    private String clientConfig;
    private boolean enabled;

    public ClusterModel() {
    }

    public ClusterModel(String name, String[] memberAddresses, boolean enabled) {
        this.name = name;
        this.memberAddresses = memberAddresses;
        this.enabled = enabled;
        this.clientConfigType = null;
        this.clientConfig = null;
    }

    public ClusterModel(ClientConfigType clientConfigType, byte[] clientConfig, boolean enabled) {
        this.clientConfigType = clientConfigType;
        this.clientConfig = new String(clientConfig, StandardCharsets.UTF_8);
        this.enabled = enabled;
        this.memberAddresses = null;
        this.name = this.createClientConfig().getClusterName();
    }

    public ClusterModel(String name, ClientConfigType clientConfigType, String clientConfig, boolean enabled) {
        this.name = name;
        this.clientConfigType = clientConfigType;
        this.clientConfig = clientConfig;
        this.enabled = enabled;
        this.memberAddresses = null;
    }

    public boolean hasConsistentClusterName() {
        return this.clientConfig == null || Objects.equals(this.name, this.createClientConfig().getClusterName());
    }

    public ClientConfig createClientConfig() {
        if (this.clientConfigType == null) {
            ClientConfig config = new ClientConfig();
            config.setClusterName(this.name);
            config.getNetworkConfig().addAddress(this.memberAddresses);
            return config;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.clientConfig.getBytes(StandardCharsets.UTF_8));
        switch (1.$SwitchMap$com$hazelcast$webmonitor$model$sql$ClusterModel$ClientConfigType[this.clientConfigType.ordinal()]) {
            case 1: {
                XmlClientConfigBuilder configBuilder = new XmlClientConfigBuilder((InputStream)in);
                return configBuilder.build();
            }
            case 2: {
                YamlClientConfigBuilder yamlConfigBuilder = new YamlClientConfigBuilder((InputStream)in);
                return yamlConfigBuilder.build();
            }
        }
        throw new IllegalArgumentException("Config type " + this.clientConfigType + " not supported!");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ClusterModelBuilder builder() {
        return new ClusterModelBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterModelBuilder toBuilder() {
        return new ClusterModelBuilder().name(this.name).memberAddresses(this.memberAddresses).clientConfigType(this.clientConfigType).clientConfig(this.clientConfig).enabled(this.enabled);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String[] getMemberAddresses() {
        return this.memberAddresses;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientConfigType getClientConfigType() {
        return this.clientConfigType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getClientConfig() {
        return this.clientConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMemberAddresses(String[] memberAddresses) {
        this.memberAddresses = memberAddresses;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientConfigType(ClientConfigType clientConfigType) {
        this.clientConfigType = clientConfigType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientConfig(String clientConfig) {
        this.clientConfig = clientConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterModel)) {
            return false;
        }
        ClusterModel other = (ClusterModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMemberAddresses(), other.getMemberAddresses())) {
            return false;
        }
        ClientConfigType this$clientConfigType = this.getClientConfigType();
        ClientConfigType other$clientConfigType = other.getClientConfigType();
        if (this$clientConfigType == null ? other$clientConfigType != null : !this$clientConfigType.equals(other$clientConfigType)) {
            return false;
        }
        String this$clientConfig = this.getClientConfig();
        String other$clientConfig = other.getClientConfig();
        return !(this$clientConfig == null ? other$clientConfig != null : !this$clientConfig.equals(other$clientConfig));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClusterModel;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMemberAddresses());
        ClientConfigType $clientConfigType = this.getClientConfigType();
        result = result * 59 + ($clientConfigType == null ? 43 : $clientConfigType.hashCode());
        String $clientConfig = this.getClientConfig();
        result = result * 59 + ($clientConfig == null ? 43 : $clientConfig.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ClusterModel(name=" + this.getName() + ", memberAddresses=" + Arrays.deepToString(this.getMemberAddresses()) + ", clientConfigType=" + this.getClientConfigType() + ", clientConfig=" + this.getClientConfig() + ", enabled=" + this.isEnabled() + ")";
    }

    @ConstructorProperties(value={"name", "memberAddresses", "clientConfigType", "clientConfig", "enabled"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterModel(String name, String[] memberAddresses, ClientConfigType clientConfigType, String clientConfig, boolean enabled) {
        this.name = name;
        this.memberAddresses = memberAddresses;
        this.clientConfigType = clientConfigType;
        this.clientConfig = clientConfig;
        this.enabled = enabled;
    }
}

