/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.model;

import com.hazelcast.webmonitor.model.ClientAttributes;
import com.hazelcast.webmonitor.model.ClientAttributesParsingResult;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

/*
 * Exception performing whole class analysis ignored.
 */
final class ClientAttributesUtil {
    static final char STAT_SEPARATOR = ',';
    static final char KEY_VALUE_SEPARATOR = '=';
    static final char ESCAPE_CHAR = '\\';

    private ClientAttributesUtil() {
    }

    public static ClientAttributesParsingResult parseClientAttributes(String uuid, String statsAsString) {
        ClientAttributes clientAttributes = new ClientAttributes();
        if (StringUtil.isNullOrEmptyAfterTrim((String)statsAsString)) {
            return new ClientAttributesParsingResult(clientAttributes, "Empty stat string for client with UUID: " + uuid + ".");
        }
        ArrayList<String> malformedKeyValuePairs = new ArrayList<String>();
        for (String keyValuePair : ClientAttributesUtil.splitStats((String)statsAsString)) {
            Map.Entry keyAndValue = ClientAttributesUtil.splitKeyValuePair((String)keyValuePair);
            if (keyAndValue == null) {
                malformedKeyValuePairs.add(keyValuePair);
                continue;
            }
            String statName = (String)keyAndValue.getKey();
            String statValue = (String)keyAndValue.getValue();
            switch (statName) {
                case "clientType": {
                    clientAttributes.setType(statValue);
                    break;
                }
                case "clientName": {
                    clientAttributes.setName(statValue);
                    break;
                }
                case "clientAddress": {
                    clientAttributes.setAddress(statValue);
                    break;
                }
                case "clientVersion": {
                    clientAttributes.setVersion(statValue);
                    break;
                }
                case "enterprise": {
                    if (StringUtil.isNullOrEmptyAfterTrim((String)statValue)) break;
                    clientAttributes.setEnterprise(Boolean.valueOf(statValue));
                    break;
                }
                case "lastStatisticsCollectionTime": {
                    clientAttributes.setLastStatisticsCollectionTime(ClientAttributesUtil.getLongOrNull((String)statValue));
                    break;
                }
                case "clusterConnectionTimestamp": {
                    clientAttributes.setClusterConnectionTimestamp(ClientAttributesUtil.getLongOrNull((String)statValue));
                    break;
                }
            }
        }
        String parsingError = null;
        if (!malformedKeyValuePairs.isEmpty()) {
            parsingError = String.format("Failed to parse client stats key/value pairs: %s, for client with UUID: %s.", malformedKeyValuePairs, uuid);
        }
        return new ClientAttributesParsingResult(clientAttributes, parsingError);
    }

    private static Long getLongOrNull(String statText) {
        if (StringUtil.isNullOrEmptyAfterTrim((String)statText)) {
            return null;
        }
        if (statText.contains(".") || statText.contains("e")) {
            return Math.round(Double.parseDouble(statText));
        }
        return Long.valueOf(statText);
    }

    static List<String> splitStats(String statString) {
        return ClientAttributesUtil.split((String)statString, (char)',', (int)Integer.MAX_VALUE);
    }

    static Map.Entry<String, String> splitKeyValuePair(String keyValuePair) {
        List tokens = ClientAttributesUtil.split((String)keyValuePair, (char)'=', (int)1);
        if (tokens.size() != 2 || StringUtil.isNullOrEmptyAfterTrim((String)((String)tokens.get(0)))) {
            return null;
        }
        return Pair.of((Object)((String)tokens.get(0)), (Object)((String)tokens.get(1)));
    }

    private static List<String> split(String stat, char splitChar, int limit) {
        int index;
        int strLen = stat.length();
        if (strLen == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        int strStart = 0;
        int previousChar = 97;
        for (index = 0; index < strLen; ++index) {
            char currentChar = stat.charAt(index);
            if (currentChar == splitChar && previousChar != 92) {
                result.add(stat.substring(strStart, index));
                strStart = index + 1;
                if (result.size() == limit) {
                    index = strLen - 1;
                }
            }
            previousChar = currentChar;
        }
        if (index >= strStart) {
            result.add(stat.substring(strStart, index));
        }
        return result;
    }
}

