/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.model;

import com.hazelcast.webmonitor.model.ClientAttributes;
import com.hazelcast.webmonitor.model.ClientAttributesParsingResult;
import com.hazelcast.webmonitor.model.ClientAttributesUtil;
import com.hazelcast.webmonitor.model.ClientConnectionInfo;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.model.hz.req.state.LocalWanPublisherStats;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.utils.MemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class AllState {
    private static final String CLIENT_MEMBER_CONNECTION_ALL = "ALL";
    private long time;
    private final Map<String, TimedMemberState> memberStateMap = new ConcurrentHashMap();
    private volatile SortedSet<String> members = new ConcurrentSkipListSet();
    private final Map<String, ClientAttributes> clientAttributesMap = new ConcurrentHashMap();
    private final EnumMap<InstanceType, SortedSet<String>> instanceNames = new EnumMap(InstanceType.class);

    public SortedSet<String> getInstanceNames(InstanceType type) {
        return this.instanceNames.computeIfAbsent(type, key -> new TreeSet());
    }

    public Map<String, ClientEndPointDTO> getClients() {
        HashMap<String, ClientEndPointDTO> clients = new HashMap<String, ClientEndPointDTO>();
        for (TimedMemberState timedMemberState : this.memberStateMap.values()) {
            MemberState memberState = timedMemberState.getMemberState();
            for (ClientEndPointDTO clientInfo : memberState.getClients()) {
                clients.put(clientInfo.getAddress(), clientInfo);
            }
        }
        return clients;
    }

    public Map<String, List<ClientEndPointDTO>> getClientsPerMember() {
        HashMap<String, List<ClientEndPointDTO>> clients = new HashMap<String, List<ClientEndPointDTO>>();
        for (TimedMemberState timedMemberState : this.memberStateMap.values()) {
            MemberState memberState = timedMemberState.getMemberState();
            clients.put(memberState.getAddress(), new ArrayList());
            for (ClientEndPointDTO clientInfo : memberState.getClients()) {
                ((List)clients.get(memberState.getAddress())).add(clientInfo);
            }
        }
        return clients;
    }

    public Map<String, List<ClientConnectionInfo>> getClientConnectionInfoPerMember() {
        HashMap<String, List<ClientConnectionInfo>> clientConnectionInfoPerMember = new HashMap<String, List<ClientConnectionInfo>>();
        Map clientsPerMember = this.getClientsPerMember();
        for (Map.Entry entry : clientsPerMember.entrySet()) {
            ArrayList<ClientConnectionInfo> clientConnectionInfoList = new ArrayList<ClientConnectionInfo>();
            for (ClientEndPointDTO clientEndPointDTO : (List)entry.getValue()) {
                long clientMatchCount = clientsPerMember.values().stream().filter(clientList -> clientList.stream().map(ClientEndPointDTO::getUuid).collect(Collectors.toList()).contains(clientEndPointDTO.getUuid())).count();
                boolean isSmartClient = clientMatchCount > 1L;
                clientConnectionInfoList.add(new ClientConnectionInfo(clientEndPointDTO.getUuid(), isSmartClient));
            }
            String memberAddress = (String)entry.getKey();
            clientConnectionInfoPerMember.put(memberAddress, clientConnectionInfoList);
        }
        return clientConnectionInfoPerMember;
    }

    public Map<String, ClientEndPointDTO> getClientsPerUuid() {
        HashMap<String, ClientEndPointDTO> clients = new HashMap<String, ClientEndPointDTO>();
        for (TimedMemberState timedMemberState : this.memberStateMap.values()) {
            MemberState memberState = timedMemberState.getMemberState();
            for (ClientEndPointDTO clientInfo : memberState.getClients()) {
                clients.put(clientInfo.getUuid(), clientInfo);
            }
        }
        return clients;
    }

    public Set<String> getClientAddresses() {
        HashSet<String> clients = new HashSet<String>();
        for (TimedMemberState timedMemberState : this.memberStateMap.values()) {
            MemberState memberState = timedMemberState.getMemberState();
            for (ClientEndPointDTO clientInfo : memberState.getClients()) {
                clients.add(clientInfo.getAddress());
            }
        }
        return clients;
    }

    public Map<String, ClientAttributes> getClientAttributes() {
        for (Map.Entry entry : this.clientAttributesMap.entrySet()) {
            String uuid = (String)entry.getKey();
            ((ClientAttributes)entry.getValue()).setMemberConnection(AllState.inferClientMemberConnection((String)uuid, (Map)this.getClientsPerMember()));
        }
        return Collections.unmodifiableMap(this.clientAttributesMap);
    }

    private static String inferClientMemberConnection(String uuid, Map<String, List<ClientEndPointDTO>> clientsPerMember) {
        int clientMatchCount = 0;
        String memberAddress = null;
        for (Map.Entry<String, List<ClientEndPointDTO>> clientsEntry : clientsPerMember.entrySet()) {
            for (ClientEndPointDTO client : clientsEntry.getValue()) {
                if (!client.getUuid().equals(uuid)) continue;
                memberAddress = clientsEntry.getKey();
                if (++clientMatchCount <= 1) continue;
                return "ALL";
            }
        }
        return memberAddress;
    }

    public Set<String> getInstanceWanPublisherSet(String scheme) {
        for (String member : this.members) {
            TimedMemberState memberState = (TimedMemberState)this.memberStateMap.get(member);
            if (!AllState.isWanStateAvailable((TimedMemberState)memberState, (String)scheme)) continue;
            return memberState.getMemberState().getLocalWanStats(scheme).getLocalWanPublisherStats().keySet();
        }
        return Collections.emptySet();
    }

    private static boolean isWanStateAvailable(TimedMemberState memberState, String scheme) {
        return memberState != null && memberState.getMemberState().getLocalWanStats(scheme) != null;
    }

    public MemberMap<TimedMemberState> getTimedMemberStates() {
        return com.hazelcast.webmonitor.utils.Collections.asMemberMap((Map)this.memberStateMap);
    }

    public Optional<TimedMemberState> getMasterState() {
        return this.memberStateMap.values().stream().filter(TimedMemberState::isMaster).findFirst();
    }

    public MemberMap<MemberState> getMemberStates() {
        return com.hazelcast.webmonitor.utils.Collections.asMemberMap((Map)this.memberStateMap, TimedMemberState::getMemberState);
    }

    public void removeMemberState(String member) {
        this.memberStateMap.remove(member);
        this.initInstanceNames();
    }

    public SortedSet<String> getMembers() {
        return this.members;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public List<String> addState(TimedMemberState memberState) {
        if (memberState.isMaster()) {
            this.members = new ConcurrentSkipListSet(memberState.getMembers());
        }
        this.memberStateMap.put(memberState.getMemberState().getAddress(), memberState);
        this.addInstanceNames(memberState);
        return this.addClientAttributes(memberState);
    }

    private void initInstanceNames() {
        this.instanceNames.clear();
        for (TimedMemberState state : this.memberStateMap.values()) {
            this.addInstanceNames(state);
        }
    }

    private void addInstanceNames(TimedMemberState state) {
        for (InstanceType type : InstanceType.values()) {
            SortedSet names = this.getInstanceNames(type);
            if (type == InstanceType.CACHE) {
                for (String name : state.getMemberState().getInstanceNames(type)) {
                    names.add(name.startsWith("/hz/") ? name.substring("/hz/".length()) : name);
                }
                continue;
            }
            names.addAll(state.getMemberState().getInstanceNames(type));
        }
    }

    private List<String> addClientAttributes(TimedMemberState memberState) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry entry : memberState.getMemberState().getClientAttributes().entrySet()) {
            String clientUuid = (String)entry.getKey();
            ClientAttributesParsingResult result = ClientAttributesUtil.parseClientAttributes((String)clientUuid, (String)((String)entry.getValue()));
            ClientAttributes attrs = result.getClientAttributes();
            result.getParsingError().ifPresent(errors::add);
            ClientAttributes old = this.clientAttributesMap.put(clientUuid, attrs);
            if (old == null || old.getLastStatisticsCollectionTime() == null || attrs.getLastStatisticsCollectionTime() == null || old.getLastStatisticsCollectionTime() <= attrs.getLastStatisticsCollectionTime()) continue;
            this.clientAttributesMap.put(clientUuid, old);
        }
        return errors;
    }

    public Map<String, LocalWanPublisherStats> getWanPublisherData(String wanReplication, String publisher) {
        if (this.members == null) {
            return Collections.emptyMap();
        }
        HashMap<String, LocalWanPublisherStats> result = new HashMap<String, LocalWanPublisherStats>();
        for (String member : this.members) {
            TimedMemberState memberState = (TimedMemberState)this.memberStateMap.get(member);
            if (memberState == null || memberState.getMemberState().getLocalWanStats(wanReplication) == null || memberState.getMemberState().getLocalWanStats(wanReplication).getLocalWanPublisherStats().get(publisher) == null) continue;
            LocalWanPublisherStats publisherStats = (LocalWanPublisherStats)memberState.getMemberState().getLocalWanStats(wanReplication).getLocalWanPublisherStats().get(publisher);
            result.put(member, publisherStats);
        }
        return result;
    }

    public List<String> getUnsafeMembers() {
        ArrayList<String> unsafeMembers = new ArrayList<String>();
        for (String member : this.members) {
            TimedMemberState memberState = (TimedMemberState)this.memberStateMap.get(member);
            if (memberState == null || memberState.getMemberState().getMemberPartitionState().isMemberStateSafe()) continue;
            unsafeMembers.add(member);
        }
        return unsafeMembers;
    }

    public List<String> getCPMemberUuids() {
        return this.memberStateMap.values().stream().map(m -> m.getMemberState().getCpMemberUuid()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean isDataAccessEnabled() {
        return this.memberStateMap.values().stream().allMatch(TimedMemberState::getMcDataAccessEnabled);
    }

    public String toString() {
        return "AllState{time=" + this.time + ", memberStateMap=" + this.memberStateMap + ", memberList=" + this.members + ", instanceNames=" + this.instanceNames + '}';
    }
}

