/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.jet;

import com.hazelcast.cluster.Member;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Tags;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.EqualsExpression;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpression;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpressions;
import com.hazelcast.webmonitor.metrics.jet.tsdb.SynchronizedTimeSeries;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeries;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeriesImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetClusterMetricsStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JetClusterMetricsStore.class);
    public static final long DEFAULT_METRICS_INTERVAL = 1000L;
    private final ConcurrentMap<String, ConcurrentMap<String, TimeSeries>> metrics = new ConcurrentHashMap();
    private static final long INTERVAL = 1000L;
    private final int numberOfPoints;
    private final ConcurrentMap<Member, Long> latestSeenTimestamps = new ConcurrentHashMap();

    public JetClusterMetricsStore(int numberOfPoints) {
        this.numberOfPoints = numberOfPoints;
    }

    public Stream<TimeSeries> query(String metric, TagExpression filter) {
        Map map = (Map)this.metrics.get(metric);
        if (map == null) {
            return Stream.empty();
        }
        return map.values().stream().filter(ts -> filter.matches(ts.tags()));
    }

    public Stream<TimeSeries> query(String metric) {
        return this.query(metric, TagExpressions.any());
    }

    public TimeSeries querySingle(String metric, TagExpression filter) {
        return (TimeSeries)this.query(metric, filter).reduce((o, n) -> {
            throw new RuntimeException("Multiple metrics found for metric=" + metric + "filter=" + filter);
        }).orElse(TimeSeriesImpl.EMPTY_TIMESERIES);
    }

    public Stream<TimeSeries> all() {
        return this.metrics.values().stream().flatMap(e -> e.values().stream());
    }

    public void removeMember(Member member) {
        log.debug("Removing metrics for " + member + " from store");
        EqualsExpression expr = TagExpressions.tagEquals((String)"member", (String)member.getUuid().toString());
        this.metrics.values().forEach(arg_0 -> JetClusterMetricsStore.lambda$removeMember$4((TagExpression)expr, arg_0));
    }

    public void storeMetricsCollection(Member member, List<MetricDataPoint> metricDataPoints) {
        if (metricDataPoints.isEmpty()) {
            return;
        }
        for (MetricDataPoint metricDataPoint : metricDataPoints) {
            Map<String, String> tags = metricDataPoint.getTags().stream().collect(Collectors.toMap(Tags.Tag::getName, Tags.Tag::getValue));
            if (!"jet".equals(tags.get("module"))) continue;
            tags.remove("module");
            String name = metricDataPoint.getName();
            tags.put("metric", name);
            tags.put("member", member.getUuid().toString());
            tags.put("address", member.getAddress().toString());
            long time = metricDataPoint.getTime();
            this.metrics.computeIfAbsent(name, k -> new ConcurrentHashMap()).computeIfAbsent(tags.toString(), k -> new SynchronizedTimeSeries((TimeSeries)new TimeSeriesImpl(tags, 1000L, this.numberOfPoints))).storePoint(time, metricDataPoint.getValue());
        }
        long latestTimestamp = metricDataPoints.stream().map(MetricDataPoint::getTime).max(Long::compareTo).orElseThrow(IllegalStateException::new);
        Long prev = this.latestSeenTimestamps.put(member, latestTimestamp);
        if (prev != null) {
            if (prev >= latestTimestamp) {
                log.warn("Received non-monotonic timestamp from {}. previous={} current={}", new Object[]{member, prev, latestTimestamp});
                return;
            }
            EqualsExpression expr = TagExpressions.tagEquals((String)"member", (String)member.getUuid().toString());
            this.metrics.values().forEach(arg_0 -> JetClusterMetricsStore.lambda$storeMetricsCollection$8(latestTimestamp, (TagExpression)expr, arg_0));
        }
    }

    private static /* synthetic */ void lambda$storeMetricsCollection$8(long latestTimestamp, TagExpression expr, ConcurrentMap m) {
        m.values().removeIf(ts -> ts.getLatestTime() + 1000L < latestTimestamp && expr.matches(ts.tags()));
    }

    private static /* synthetic */ void lambda$removeMember$4(TagExpression expr, ConcurrentMap m) {
        m.values().removeIf(ts -> expr.matches(ts.tags()));
    }
}

