/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.utils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class TimeUtil {
    private static final int SEC_IN_MIN = 60;
    public static final long MS_IN_SEC = 1000L;
    public static final long MS_IN_MIN = 60000L;

    private TimeUtil() {
    }

    public static long minuteStart(long time) {
        return time - time % 60000L;
    }

    public static long prevMinuteStart(long time) {
        return TimeUtil.minuteStart((long)time) - 60000L;
    }

    public static boolean isMinuteStart(long time) {
        return time % 60000L == 0L;
    }

    public static int minuteOffset(long time) {
        return (int)((time - TimeUtil.minuteStart((long)time)) / 1000L);
    }

    public static long[] minuteStarts(long start, long end) {
        if (start > end) {
            throw new IllegalArgumentException("Range start must not be later than range end.");
        }
        long left = TimeUtil.minuteStart((long)start);
        long right = TimeUtil.minuteStart((long)end) + 1L;
        int size = (int)((right - left) / 60000L) + 1;
        long[] res = new long[size];
        for (int i = 0; i < size; ++i) {
            res[i] = left + (long)i * 60000L;
        }
        return res;
    }

    public static long[] minuteTimePoints(long minStart) {
        if (!TimeUtil.isMinuteStart((long)minStart)) {
            throw new IllegalArgumentException("Minute start must be provided.");
        }
        long[] res = new long[60];
        for (int i = 0; i < res.length; ++i) {
            res[i] = minStart + (long)i * 1000L;
        }
        return res;
    }

    public static long minuteTimePoint(long minStart, int offset) {
        if (!TimeUtil.isMinuteStart((long)minStart)) {
            throw new IllegalArgumentException("Minute start must be provided.");
        }
        if (offset < 0 || offset >= 60) {
            throw new IllegalArgumentException("Offset must be within 0-59 range.");
        }
        return minStart + (long)offset * 1000L;
    }
}

