/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.utils;

import com.hazelcast.internal.metrics.MetricDescriptor;
import java.math.BigDecimal;
import java.math.RoundingMode;

public final class MetricsUtil {
    private static final int CONVERSION_PRECISION = 2;
    private static final double DOUBLE_TO_LONG = Math.pow(10.0, 2.0);

    private MetricsUtil() {
    }

    public static double toOriginalMetricValue(long value) {
        return BigDecimal.valueOf((double)value / DOUBLE_TO_LONG).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public static long toInternalMetricValue(double value) {
        return Math.round(value * DOUBLE_TO_LONG);
    }

    public static String metricName(MetricDescriptor descriptor) {
        if (descriptor.prefix() != null) {
            return descriptor.prefix() + "." + descriptor.metric();
        }
        return descriptor.metric();
    }
}

