/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.utils;

import java.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ByteUtil {
    private static final long MAX_VALUE_1_BYTE = 31L;
    private static final long MAX_VALUE_2_BYTES = 8191L;
    private static final long MAX_VALUE_4_BYTES = 0x1FFFFFFFL;
    private static final int OP_PLAIN_LONG = 0;
    private static final int OP_SAME = 32;
    private static final int OP_BYTE_POSITIVE = 64;
    private static final int OP_BYTE_NEGATIVE = 96;
    private static final int OP_SHORT_POSITIVE = 128;
    private static final int OP_SHORT_NEGATIVE = 160;
    private static final int OP_INT_POSITIVE = 192;
    private static final int OP_INT_NEGATIVE = 224;
    private static final int VALUE_MASK = 31;
    private static final int OPERATION_MASK = 224;
    private static final int NO_MASK = 255;
    private static final int BYTE_MASK = 255;

    private ByteUtil() {
    }

    public static byte[] deltaCompress(long[] values) {
        return ByteUtil.deltaCompress((long[])values, (int)values.length);
    }

    public static byte[] deltaCompress(long[] values, int length) {
        if (length > values.length) {
            throw new IllegalArgumentException("Invalid length specified.");
        }
        if (length > Short.MAX_VALUE) {
            throw new UnsupportedOperationException("Currently this is optimized for arrays shorter than 32767 elements.");
        }
        byte[] compressed = new byte[length + 8];
        long last = 0L;
        int j = 0;
        boolean wasSame = false;
        int lastLongIndex = -1;
        for (int i = 0; i < length; ++i) {
            long val = values[i];
            if (val == last) {
                int times;
                int n = times = wasSame ? compressed[j - 1] & 0x1F : 0;
                if (times > 0 && (long)times < 31L) {
                    compressed[j - 1] = (byte)(0x20 | times + 1);
                } else {
                    compressed = ByteUtil.ensureCapacity((byte[])compressed, (int)j, (int)1);
                    compressed[j++] = 33;
                }
            } else {
                boolean neg;
                long absDelta;
                try {
                    long delta = Math.subtractExact(val, last);
                    absDelta = delta < 0L ? Math.negateExact(delta) : delta;
                    neg = delta < 0L;
                }
                catch (ArithmeticException e) {
                    absDelta = Long.MAX_VALUE;
                    neg = false;
                }
                if (absDelta <= 31L) {
                    compressed = ByteUtil.ensureCapacity((byte[])compressed, (int)j, (int)1);
                    compressed[j++] = (byte)(absDelta | (long)(neg ? 96 : 64));
                } else if (absDelta <= 8191L) {
                    compressed = ByteUtil.ensureCapacity((byte[])compressed, (int)j, (int)2);
                    ByteUtil.writeShort((int)j, (byte[])compressed, (short)((short)absDelta));
                    int n = j;
                    compressed[n] = (byte)(compressed[n] | (neg ? 160 : 128));
                    j += 2;
                } else if (absDelta <= 0x1FFFFFFFL) {
                    compressed = ByteUtil.ensureCapacity((byte[])compressed, (int)j, (int)4);
                    ByteUtil.writeInt((int)j, (byte[])compressed, (int)((int)absDelta));
                    int n = j;
                    compressed[n] = (byte)(compressed[n] | (neg ? 224 : 192));
                    j += 4;
                } else {
                    byte count;
                    byte by = count = lastLongIndex < 0 ? (byte)0 : compressed[lastLongIndex];
                    if (count == 0 || (long)count >= 31L || count * 8 + lastLongIndex + 1 < j) {
                        lastLongIndex = j;
                        compressed = ByteUtil.ensureCapacity((byte[])compressed, (int)j, (int)9);
                        compressed[j++] = 1;
                    } else {
                        compressed[lastLongIndex] = (byte)(compressed[lastLongIndex] + 1);
                        compressed = ByteUtil.ensureCapacity((byte[])compressed, (int)j, (int)8);
                    }
                    ByteUtil.writeLong((int)j, (byte[])compressed, (long)val);
                    j += 8;
                }
            }
            wasSame = last == val;
            last = val;
        }
        return j == compressed.length ? compressed : Arrays.copyOf(compressed, j);
    }

    private static byte[] ensureCapacity(byte[] arr, int offset, int length) {
        if (offset + length > arr.length) {
            return Arrays.copyOf(arr, Math.max(offset + length, arr.length + arr.length / 4));
        }
        return arr;
    }

    public static long[] deltaUncompress(byte[] deltaCompressed, int length) {
        if (deltaCompressed == null) {
            return null;
        }
        if (length < 0) {
            throw new IllegalArgumentException("Invalid length specified.");
        }
        long[] values = new long[length];
        long cur = 0L;
        int i = 0;
        int j = 0;
        while (i < values.length && j < deltaCompressed.length) {
            byte op = deltaCompressed[j];
            switch (op & 0xE0) {
                case 64: {
                    cur += (long)(deltaCompressed[j++] & 0x1F);
                    break;
                }
                case 96: {
                    cur -= (long)(deltaCompressed[j++] & 0x1F);
                    break;
                }
                case 128: {
                    cur += (long)ByteUtil.readShort((int)j, (byte[])deltaCompressed, (int)31);
                    j += 2;
                    break;
                }
                case 160: {
                    cur -= (long)ByteUtil.readShort((int)j, (byte[])deltaCompressed, (int)31);
                    j += 2;
                    break;
                }
                case 192: {
                    cur += (long)ByteUtil.readInt((int)j, (byte[])deltaCompressed, (int)31);
                    j += 4;
                    break;
                }
                case 224: {
                    cur -= (long)ByteUtil.readInt((int)j, (byte[])deltaCompressed, (int)31);
                    j += 4;
                    break;
                }
                case 0: {
                    int k;
                    int times = (op & 0x1F) - 1;
                    ++j;
                    for (k = 0; k < times; ++k) {
                        values[i++] = ByteUtil.readLong((int)j, (byte[])deltaCompressed);
                        j += 8;
                    }
                    cur = ByteUtil.readLong((int)j, (byte[])deltaCompressed);
                    j += 8;
                    break;
                }
                case 32: {
                    int k;
                    int times = (op & 0x1F) - 1;
                    for (k = 0; k < times; ++k) {
                        values[i++] = cur;
                    }
                    ++j;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            values[i++] = cur;
        }
        if (j < deltaCompressed.length || i < values.length) {
            throw new IllegalArgumentException("The value passed does not seam to be a valid delta compressed array.");
        }
        return values;
    }

    static int unsignedByte(byte val) {
        return val & 0xFF;
    }

    static byte unsignedByte(int val) {
        return (byte)(val & 0xFF);
    }

    static byte unsignedByte(long val) {
        return (byte)(val & 0xFFL);
    }

    static short readShort(int at, byte[] arr, int mask) {
        return (short)((ByteUtil.unsignedByte((int)(arr[at] & mask)) << 8) + ByteUtil.unsignedByte((byte)arr[at + 1]));
    }

    static int readInt(int at, byte[] arr) {
        return ByteUtil.readInt((int)at, (byte[])arr, (int)255);
    }

    static int readInt(int at, byte[] arr, int mask) {
        return (ByteUtil.unsignedByte((int)(arr[at] & mask)) << 24) + (ByteUtil.unsignedByte((byte)arr[at + 1]) << 16) + (ByteUtil.unsignedByte((byte)arr[at + 2]) << 8) + ByteUtil.unsignedByte((byte)arr[at + 3]);
    }

    static long readLong(int at, byte[] arr) {
        return ((long)ByteUtil.unsignedByte((byte)arr[at]) << 56) + ((long)ByteUtil.unsignedByte((byte)arr[at + 1]) << 48) + ((long)ByteUtil.unsignedByte((byte)arr[at + 2]) << 40) + ((long)ByteUtil.unsignedByte((byte)arr[at + 3]) << 32) + ((long)ByteUtil.unsignedByte((byte)arr[at + 4]) << 24) + (long)(ByteUtil.unsignedByte((byte)arr[at + 5]) << 16) + (long)(ByteUtil.unsignedByte((byte)arr[at + 6]) << 8) + (long)ByteUtil.unsignedByte((byte)arr[at + 7]);
    }

    static void writeShort(int at, byte[] arr, short val) {
        arr[at] = ByteUtil.unsignedByte((int)(val >>> 8));
        arr[at + 1] = ByteUtil.unsignedByte((int)val);
    }

    static void writeInt(int at, byte[] arr, int val) {
        arr[at] = ByteUtil.unsignedByte((int)(val >>> 24));
        arr[at + 1] = ByteUtil.unsignedByte((int)(val >>> 16));
        arr[at + 2] = ByteUtil.unsignedByte((int)(val >>> 8));
        arr[at + 3] = ByteUtil.unsignedByte((int)val);
    }

    static void writeLong(int at, byte[] arr, long val) {
        arr[at] = ByteUtil.unsignedByte((long)(val >>> 56));
        arr[at + 1] = ByteUtil.unsignedByte((long)(val >>> 48));
        arr[at + 2] = ByteUtil.unsignedByte((long)(val >>> 40));
        arr[at + 3] = ByteUtil.unsignedByte((long)(val >>> 32));
        arr[at + 4] = ByteUtil.unsignedByte((long)(val >>> 24));
        arr[at + 5] = ByteUtil.unsignedByte((long)(val >>> 16));
        arr[at + 6] = ByteUtil.unsignedByte((long)(val >>> 8));
        arr[at + 7] = ByteUtil.unsignedByte((long)val);
    }
}

