/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.serde;

import com.hazelcast.webmonitor.metrics.impl.serde.ByteArrayInput;
import com.hazelcast.webmonitor.metrics.impl.serde.ByteArrayOutput;

public abstract class Serde<S, D> {
    static final ThreadLocal<ByteArrayOutput> BYTE_ARRAY_OUTPUT_THREAD_LOCAL = ThreadLocal.withInitial(ByteArrayOutput::new);
    static final ThreadLocal<ByteArrayInput> BYTE_ARRAY_INPUT_THREAD_LOCAL = ThreadLocal.withInitial(ByteArrayInput::new);

    public final byte[] serialize(S value) {
        ByteArrayOutput byteArrayOutput = (ByteArrayOutput)BYTE_ARRAY_OUTPUT_THREAD_LOCAL.get();
        byteArrayOutput.resetPosition();
        this.doSerialize(byteArrayOutput, value);
        return byteArrayOutput.toArray();
    }

    protected abstract void doSerialize(ByteArrayOutput var1, S var2);

    public final D deserialize(byte[] in) {
        ByteArrayInput byteArrayInput = (ByteArrayInput)BYTE_ARRAY_INPUT_THREAD_LOCAL.get();
        byteArrayInput.resetDataAndPosition(in);
        return (D)this.doDeserialize(byteArrayInput);
    }

    protected abstract D doDeserialize(ByteArrayInput var1);
}

