/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.serde;

import java.util.Arrays;

public class ByteArrayOutput {
    private static final int INITIAL_SIZE = 128;
    private static final int GROW_FACTOR = 2;
    private byte[] buf = new byte[128];
    private int pos;

    public byte[] toArray() {
        return Arrays.copyOf(this.buf, this.pos);
    }

    public void writeBoolean(boolean value) {
        this.writeByte((byte)(value ? 1 : 0));
    }

    public void writeByte(byte value) {
        this.ensureAvailable(1);
        this.buf[this.pos++] = value;
    }

    public void writeShort(int value) {
        this.ensureAvailable(2);
        this.buf[this.pos++] = (byte)(0xFF & value >> 8);
        this.buf[this.pos++] = (byte)(0xFF & value);
    }

    public void writeInt(int value) {
        this.ensureAvailable(4);
        this.buf[this.pos++] = (byte)(0xFF & value >> 24);
        this.buf[this.pos++] = (byte)(0xFF & value >> 16);
        this.buf[this.pos++] = (byte)(0xFF & value >> 8);
        this.buf[this.pos++] = (byte)(0xFF & value);
    }

    public void writeLong(long value) {
        this.ensureAvailable(8);
        this.buf[this.pos++] = (byte)(0xFFL & value >> 56);
        this.buf[this.pos++] = (byte)(0xFFL & value >> 48);
        this.buf[this.pos++] = (byte)(0xFFL & value >> 40);
        this.buf[this.pos++] = (byte)(0xFFL & value >> 32);
        this.buf[this.pos++] = (byte)(0xFFL & value >> 24);
        this.buf[this.pos++] = (byte)(0xFFL & value >> 16);
        this.buf[this.pos++] = (byte)(0xFFL & value >> 8);
        this.buf[this.pos++] = (byte)(0xFFL & value);
    }

    public void writeUTF(String str) {
        int len = str.length();
        this.writeInt(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            this.writeInt((int)c);
        }
    }

    public void writeByteArray(byte[] array) {
        this.ensureAvailable(array.length);
        for (byte b : array) {
            this.buf[this.pos++] = b;
        }
    }

    public void resetPosition() {
        this.pos = 0;
    }

    private void ensureAvailable(int size) {
        if (this.available() < size) {
            this.grow(size);
        }
    }

    private void grow(int size) {
        int newCap = Math.max(this.buf.length * 2, this.buf.length + size);
        this.buf = Arrays.copyOf(this.buf, newCap);
    }

    private int available() {
        return this.buf.length - this.pos;
    }
}

